package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KafkaClusterEncryptionInTransitDescription(
    encryptionType: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription = {
    import KafkaClusterEncryptionInTransitDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription
      .builder()
      .optionallyWith(encryptionType.map(value => value.unwrap))(
        _.encryptionType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription.ReadOnly =
    zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription
      .wrap(buildAwsValue())
}
object KafkaClusterEncryptionInTransitDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription =
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription(
        encryptionType.map(value => value)
      )
    def encryptionType: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
    ]
    def getEncryptionType: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
    ] = AwsError.unwrapOptionField("encryptionType", encryptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription
  ) extends zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription.ReadOnly {
    override val encryptionType: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionType())
      .map(value =>
        zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription
  ): zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription.ReadOnly =
    new Wrapper(impl)
}
