package zio.aws.kafkaconnect.model
import scala.jdk.CollectionConverters.*
sealed trait KafkaClusterEncryptionInTransitType {
  def unwrap: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType
}
object KafkaClusterEncryptionInTransitType {
  def wrap(
      value: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType
  ): zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType =
    value match {
      case software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType.PLAINTEXT =>
        val r = PLAINTEXT
        r
      case software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType.TLS =>
        val r = TLS
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType =
      software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType.UNKNOWN_TO_SDK_VERSION
  }
  case object PLAINTEXT
      extends zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType =
      software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType.PLAINTEXT
  }
  case object TLS
      extends zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType =
      software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitType.TLS
  }
}
