package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Plugin(customPlugin: zio.aws.kafkaconnect.model.CustomPlugin) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.Plugin = {
    import Plugin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.Plugin
      .builder()
      .customPlugin(customPlugin.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.Plugin.ReadOnly =
    zio.aws.kafkaconnect.model.Plugin.wrap(buildAwsValue())
}
object Plugin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.Plugin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.Plugin =
      zio.aws.kafkaconnect.model.Plugin(customPlugin.asEditable)
    def customPlugin: zio.aws.kafkaconnect.model.CustomPlugin.ReadOnly
    def getCustomPlugin
        : ZIO[Any, Nothing, zio.aws.kafkaconnect.model.CustomPlugin.ReadOnly] =
      ZIO.succeed(customPlugin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.Plugin
  ) extends zio.aws.kafkaconnect.model.Plugin.ReadOnly {
    override val customPlugin
        : zio.aws.kafkaconnect.model.CustomPlugin.ReadOnly =
      zio.aws.kafkaconnect.model.CustomPlugin.wrap(impl.customPlugin())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.Plugin
  ): zio.aws.kafkaconnect.model.Plugin.ReadOnly = new Wrapper(impl)
}
