package zio.aws.kafkaconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.{
  __integerMin1Max10,
  __integerMin1Max8
}
import scala.jdk.CollectionConverters.*
final case class ProvisionedCapacity(
    mcuCount: __integerMin1Max8,
    workerCount: __integerMin1Max10
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacity = {
    import ProvisionedCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacity
      .builder()
      .mcuCount(mcuCount: Integer)
      .workerCount(workerCount: Integer)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ProvisionedCapacity.ReadOnly =
    zio.aws.kafkaconnect.model.ProvisionedCapacity.wrap(buildAwsValue())
}
object ProvisionedCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ProvisionedCapacity =
      zio.aws.kafkaconnect.model.ProvisionedCapacity(mcuCount, workerCount)
    def mcuCount: __integerMin1Max8
    def workerCount: __integerMin1Max10
    def getMcuCount: ZIO[Any, Nothing, __integerMin1Max8] =
      ZIO.succeed(mcuCount)
    def getWorkerCount: ZIO[Any, Nothing, __integerMin1Max10] =
      ZIO.succeed(workerCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacity
  ) extends zio.aws.kafkaconnect.model.ProvisionedCapacity.ReadOnly {
    override val mcuCount: __integerMin1Max8 =
      impl.mcuCount(): __integerMin1Max8
    override val workerCount: __integerMin1Max10 =
      impl.workerCount(): __integerMin1Max10
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacity
  ): zio.aws.kafkaconnect.model.ProvisionedCapacity.ReadOnly = new Wrapper(impl)
}
