package zio.aws.kafkaconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.{
  __integerMin1Max10,
  __integerMin1Max8
}
import scala.jdk.CollectionConverters.*
final case class ProvisionedCapacityUpdate(
    mcuCount: __integerMin1Max8,
    workerCount: __integerMin1Max10
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityUpdate = {
    import ProvisionedCapacityUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityUpdate
      .builder()
      .mcuCount(mcuCount: Integer)
      .workerCount(workerCount: Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate.ReadOnly =
    zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate.wrap(buildAwsValue())
}
object ProvisionedCapacityUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate =
      zio.aws.kafkaconnect.model
        .ProvisionedCapacityUpdate(mcuCount, workerCount)
    def mcuCount: __integerMin1Max8
    def workerCount: __integerMin1Max10
    def getMcuCount: ZIO[Any, Nothing, __integerMin1Max8] =
      ZIO.succeed(mcuCount)
    def getWorkerCount: ZIO[Any, Nothing, __integerMin1Max10] =
      ZIO.succeed(workerCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityUpdate
  ) extends zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate.ReadOnly {
    override val mcuCount: __integerMin1Max8 =
      impl.mcuCount(): __integerMin1Max8
    override val workerCount: __integerMin1Max10 =
      impl.workerCount(): __integerMin1Max10
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityUpdate
  ): zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate.ReadOnly =
    new Wrapper(impl)
}
