package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class S3LocationDescription(
    bucketArn: Optional[__string] = Optional.Absent,
    fileKey: Optional[__string] = Optional.Absent,
    objectVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.S3LocationDescription = {
    import S3LocationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.S3LocationDescription
      .builder()
      .optionallyWith(bucketArn.map(value => value: java.lang.String))(
        _.bucketArn
      )
      .optionallyWith(fileKey.map(value => value: java.lang.String))(_.fileKey)
      .optionallyWith(objectVersion.map(value => value: java.lang.String))(
        _.objectVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.S3LocationDescription.ReadOnly =
    zio.aws.kafkaconnect.model.S3LocationDescription.wrap(buildAwsValue())
}
object S3LocationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.S3LocationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.S3LocationDescription =
      zio.aws.kafkaconnect.model.S3LocationDescription(
        bucketArn.map(value => value),
        fileKey.map(value => value),
        objectVersion.map(value => value)
      )
    def bucketArn: Optional[__string]
    def fileKey: Optional[__string]
    def objectVersion: Optional[__string]
    def getBucketArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getFileKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fileKey", fileKey)
    def getObjectVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("objectVersion", objectVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.S3LocationDescription
  ) extends zio.aws.kafkaconnect.model.S3LocationDescription.ReadOnly {
    override val bucketArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketArn())
      .map(value => value: __string)
    override val fileKey: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.fileKey())
      .map(value => value: __string)
    override val objectVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.objectVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.S3LocationDescription
  ): zio.aws.kafkaconnect.model.S3LocationDescription.ReadOnly = new Wrapper(
    impl
  )
}
