package zio.aws.kafkaconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.__integerMin1Max100
import scala.jdk.CollectionConverters.*
final case class ScaleInPolicyUpdate(
    cpuUtilizationPercentage: __integerMin1Max100
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyUpdate = {
    import ScaleInPolicyUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyUpdate
      .builder()
      .cpuUtilizationPercentage(cpuUtilizationPercentage: Integer)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ScaleInPolicyUpdate.ReadOnly =
    zio.aws.kafkaconnect.model.ScaleInPolicyUpdate.wrap(buildAwsValue())
}
object ScaleInPolicyUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ScaleInPolicyUpdate =
      zio.aws.kafkaconnect.model.ScaleInPolicyUpdate(cpuUtilizationPercentage)
    def cpuUtilizationPercentage: __integerMin1Max100
    def getCpuUtilizationPercentage: ZIO[Any, Nothing, __integerMin1Max100] =
      ZIO.succeed(cpuUtilizationPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyUpdate
  ) extends zio.aws.kafkaconnect.model.ScaleInPolicyUpdate.ReadOnly {
    override val cpuUtilizationPercentage: __integerMin1Max100 =
      impl.cpuUtilizationPercentage(): __integerMin1Max100
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyUpdate
  ): zio.aws.kafkaconnect.model.ScaleInPolicyUpdate.ReadOnly = new Wrapper(impl)
}
