package zio.aws.kafkaconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.__integerMin1Max100
import scala.jdk.CollectionConverters.*
final case class ScaleOutPolicyUpdate(
    cpuUtilizationPercentage: __integerMin1Max100
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicyUpdate = {
    import ScaleOutPolicyUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicyUpdate
      .builder()
      .cpuUtilizationPercentage(cpuUtilizationPercentage: Integer)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate.ReadOnly =
    zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate.wrap(buildAwsValue())
}
object ScaleOutPolicyUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicyUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate =
      zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate(cpuUtilizationPercentage)
    def cpuUtilizationPercentage: __integerMin1Max100
    def getCpuUtilizationPercentage: ZIO[Any, Nothing, __integerMin1Max100] =
      ZIO.succeed(cpuUtilizationPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicyUpdate
  ) extends zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate.ReadOnly {
    override val cpuUtilizationPercentage: __integerMin1Max100 =
      impl.cpuUtilizationPercentage(): __integerMin1Max100
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicyUpdate
  ): zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate.ReadOnly = new Wrapper(
    impl
  )
}
