package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateConnectorRequest(
    capacity: zio.aws.kafkaconnect.model.CapacityUpdate,
    connectorArn: __string,
    currentVersion: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest = {
    import UpdateConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest
      .builder()
      .capacity(capacity.buildAwsValue())
      .connectorArn(connectorArn: java.lang.String)
      .currentVersion(currentVersion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.UpdateConnectorRequest.ReadOnly =
    zio.aws.kafkaconnect.model.UpdateConnectorRequest.wrap(buildAwsValue())
}
object UpdateConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.UpdateConnectorRequest =
      zio.aws.kafkaconnect.model.UpdateConnectorRequest(
        capacity.asEditable,
        connectorArn,
        currentVersion
      )
    def capacity: zio.aws.kafkaconnect.model.CapacityUpdate.ReadOnly
    def connectorArn: __string
    def currentVersion: __string
    def getCapacity: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.CapacityUpdate.ReadOnly
    ] = ZIO.succeed(capacity)
    def getConnectorArn: ZIO[Any, Nothing, __string] = ZIO.succeed(connectorArn)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest
  ) extends zio.aws.kafkaconnect.model.UpdateConnectorRequest.ReadOnly {
    override val capacity: zio.aws.kafkaconnect.model.CapacityUpdate.ReadOnly =
      zio.aws.kafkaconnect.model.CapacityUpdate.wrap(impl.capacity())
    override val connectorArn: __string = impl.connectorArn(): __string
    override val currentVersion: __string = impl.currentVersion(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest
  ): zio.aws.kafkaconnect.model.UpdateConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
