package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class VpcDescription(
    securityGroups: Optional[Iterable[__string]] = Optional.Absent,
    subnets: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.VpcDescription = {
    import VpcDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.VpcDescription
      .builder()
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.VpcDescription.ReadOnly =
    zio.aws.kafkaconnect.model.VpcDescription.wrap(buildAwsValue())
}
object VpcDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.VpcDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.VpcDescription =
      zio.aws.kafkaconnect.model.VpcDescription(
        securityGroups.map(value => value),
        subnets.map(value => value)
      )
    def securityGroups: Optional[List[__string]]
    def subnets: Optional[List[__string]]
    def getSecurityGroups: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnets: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.VpcDescription
  ) extends zio.aws.kafkaconnect.model.VpcDescription.ReadOnly {
    override val securityGroups: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val subnets: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.VpcDescription
  ): zio.aws.kafkaconnect.model.VpcDescription.ReadOnly = new Wrapper(impl)
}
