package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkerLogDelivery(
    cloudWatchLogs: Optional[
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery
    ] = Optional.Absent,
    firehose: Optional[zio.aws.kafkaconnect.model.FirehoseLogDelivery] =
      Optional.Absent,
    s3: Optional[zio.aws.kafkaconnect.model.S3LogDelivery] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDelivery = {
    import WorkerLogDelivery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDelivery
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(firehose.map(value => value.buildAwsValue()))(_.firehose)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.WorkerLogDelivery.ReadOnly =
    zio.aws.kafkaconnect.model.WorkerLogDelivery.wrap(buildAwsValue())
}
object WorkerLogDelivery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDelivery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.WorkerLogDelivery =
      zio.aws.kafkaconnect.model.WorkerLogDelivery(
        cloudWatchLogs.map(value => value.asEditable),
        firehose.map(value => value.asEditable),
        s3.map(value => value.asEditable)
      )
    def cloudWatchLogs: Optional[
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery.ReadOnly
    ]
    def firehose
        : Optional[zio.aws.kafkaconnect.model.FirehoseLogDelivery.ReadOnly]
    def s3: Optional[zio.aws.kafkaconnect.model.S3LogDelivery.ReadOnly]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getFirehose: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.FirehoseLogDelivery.ReadOnly
    ] = AwsError.unwrapOptionField("firehose", firehose)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.S3LogDelivery.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDelivery
  ) extends zio.aws.kafkaconnect.model.WorkerLogDelivery.ReadOnly {
    override val cloudWatchLogs: Optional[
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery.wrap(value)
      )
    override val firehose
        : Optional[zio.aws.kafkaconnect.model.FirehoseLogDelivery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firehose())
        .map(value =>
          zio.aws.kafkaconnect.model.FirehoseLogDelivery.wrap(value)
        )
    override val s3
        : Optional[zio.aws.kafkaconnect.model.S3LogDelivery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.kafkaconnect.model.S3LogDelivery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDelivery
  ): zio.aws.kafkaconnect.model.WorkerLogDelivery.ReadOnly = new Wrapper(impl)
}
