package zio.aws.kafkaconnect
import zio.aws.kafkaconnect.model.CustomPluginSummary.ReadOnly
import software.amazon.awssdk.services.kafkaconnect.paginators.{
  ListConnectorsPublisher,
  ListCustomPluginsPublisher,
  ListWorkerConfigurationsPublisher
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.kafkaconnect.model.{
  UpdateConnectorRequest,
  ListWorkerConfigurationsRequest,
  DescribeWorkerConfigurationRequest,
  CreateWorkerConfigurationRequest,
  DescribeConnectorRequest,
  DescribeCustomPluginRequest,
  DeleteCustomPluginRequest,
  DeleteConnectorRequest,
  ListConnectorsRequest,
  CreateCustomPluginRequest,
  ListCustomPluginsRequest,
  CreateConnectorRequest
}
import software.amazon.awssdk.services.kafkaconnect.model.{
  DeleteCustomPluginResponse,
  ListWorkerConfigurationsResponse,
  CreateWorkerConfigurationResponse,
  CustomPluginSummary,
  UpdateConnectorResponse,
  ListConnectorsResponse,
  WorkerConfigurationSummary,
  DescribeWorkerConfigurationResponse,
  CreateCustomPluginResponse,
  ConnectorSummary,
  CreateConnectorResponse,
  ListCustomPluginsResponse,
  DeleteConnectorResponse,
  DescribeConnectorResponse,
  DescribeCustomPluginResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.kafkaconnect.{
  KafkaConnectAsyncClientBuilder,
  KafkaConnectAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait KafkaConnect extends AspectSupport[KafkaConnect] {
  val api: KafkaConnectAsyncClient
  def deleteCustomPlugin(request: DeleteCustomPluginRequest): IO[
    AwsError,
    zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.ReadOnly
  ]
  def updateConnector(
      request: UpdateConnectorRequest
  ): IO[AwsError, zio.aws.kafkaconnect.model.UpdateConnectorResponse.ReadOnly]
  def createCustomPlugin(request: CreateCustomPluginRequest): IO[
    AwsError,
    zio.aws.kafkaconnect.model.CreateCustomPluginResponse.ReadOnly
  ]
  def deleteConnector(
      request: DeleteConnectorRequest
  ): IO[AwsError, zio.aws.kafkaconnect.model.DeleteConnectorResponse.ReadOnly]
  def createConnector(
      request: CreateConnectorRequest
  ): IO[AwsError, zio.aws.kafkaconnect.model.CreateConnectorResponse.ReadOnly]
  def describeConnector(
      request: DescribeConnectorRequest
  ): IO[AwsError, zio.aws.kafkaconnect.model.DescribeConnectorResponse.ReadOnly]
  def listWorkerConfigurations(
      request: ListWorkerConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.kafkaconnect.model.WorkerConfigurationSummary.ReadOnly
  ]
  def listWorkerConfigurationsPaginated(
      request: ListWorkerConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.ReadOnly
  ]
  def createWorkerConfiguration(request: CreateWorkerConfigurationRequest): IO[
    AwsError,
    zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.ReadOnly
  ]
  def describeWorkerConfiguration(
      request: DescribeWorkerConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.ReadOnly
  ]
  def listCustomPlugins(
      request: ListCustomPluginsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listCustomPluginsPaginated(
      request: ListCustomPluginsRequest
  ): IO[AwsError, zio.aws.kafkaconnect.model.ListCustomPluginsResponse.ReadOnly]
  def listConnectors(request: ListConnectorsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.kafkaconnect.model.ConnectorSummary.ReadOnly
  ]
  def listConnectorsPaginated(
      request: ListConnectorsRequest
  ): IO[AwsError, zio.aws.kafkaconnect.model.ListConnectorsResponse.ReadOnly]
  def describeCustomPlugin(request: DescribeCustomPluginRequest): IO[
    AwsError,
    zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.ReadOnly
  ]
}
object KafkaConnect {
  val live: ZLayer[AwsConfig, java.lang.Throwable, KafkaConnect] = customized(
    identity
  )
  def customized(
      customization: KafkaConnectAsyncClientBuilder => KafkaConnectAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, KafkaConnect] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: KafkaConnectAsyncClientBuilder => KafkaConnectAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, KafkaConnect] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = KafkaConnectAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[KafkaConnectAsyncClient, KafkaConnectAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      KafkaConnectAsyncClient,
      KafkaConnectAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new KafkaConnectImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class KafkaConnectImpl[R](
      override val api: KafkaConnectAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends KafkaConnect
      with AwsServiceBase[R] {
    override val serviceName: String = "KafkaConnect"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KafkaConnectImpl[R1] = new KafkaConnectImpl(api, newAspect, r)
    def deleteCustomPlugin(request: DeleteCustomPluginRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginRequest,
      DeleteCustomPluginResponse
    ]("deleteCustomPlugin", api.deleteCustomPlugin)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.wrap)
      .provideEnvironment(r)
    def updateConnector(request: UpdateConnectorRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.UpdateConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest,
      UpdateConnectorResponse
    ]("updateConnector", api.updateConnector)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.UpdateConnectorResponse.wrap)
      .provideEnvironment(r)
    def createCustomPlugin(request: CreateCustomPluginRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.CreateCustomPluginResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest,
      CreateCustomPluginResponse
    ]("createCustomPlugin", api.createCustomPlugin)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.CreateCustomPluginResponse.wrap)
      .provideEnvironment(r)
    def deleteConnector(request: DeleteConnectorRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.DeleteConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest,
      DeleteConnectorResponse
    ]("deleteConnector", api.deleteConnector)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.DeleteConnectorResponse.wrap)
      .provideEnvironment(r)
    def createConnector(request: CreateConnectorRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.CreateConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest,
      CreateConnectorResponse
    ]("createConnector", api.createConnector)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.CreateConnectorResponse.wrap)
      .provideEnvironment(r)
    def describeConnector(request: DescribeConnectorRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.DescribeConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorRequest,
      DescribeConnectorResponse
    ]("describeConnector", api.describeConnector)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.DescribeConnectorResponse.wrap)
      .provideEnvironment(r)
    def listWorkerConfigurations(
        request: ListWorkerConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.WorkerConfigurationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest,
      WorkerConfigurationSummary,
      ListWorkerConfigurationsPublisher
    ](
      "listWorkerConfigurations",
      api.listWorkerConfigurationsPaginator,
      _.workerConfigurations()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.kafkaconnect.model.WorkerConfigurationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listWorkerConfigurationsPaginated(
        request: ListWorkerConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest,
      ListWorkerConfigurationsResponse
    ]("listWorkerConfigurations", api.listWorkerConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def createWorkerConfiguration(
        request: CreateWorkerConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest,
      CreateWorkerConfigurationResponse
    ]("createWorkerConfiguration", api.createWorkerConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeWorkerConfiguration(
        request: DescribeWorkerConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationRequest,
      DescribeWorkerConfigurationResponse
    ]("describeWorkerConfiguration", api.describeWorkerConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listCustomPlugins(
        request: ListCustomPluginsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest,
      CustomPluginSummary,
      ListCustomPluginsPublisher
    ]("listCustomPlugins", api.listCustomPluginsPaginator, _.customPlugins())(
      request.buildAwsValue()
    ).map(item => zio.aws.kafkaconnect.model.CustomPluginSummary.wrap(item))
      .provideEnvironment(r)
    def listCustomPluginsPaginated(request: ListCustomPluginsRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.ListCustomPluginsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest,
      ListCustomPluginsResponse
    ]("listCustomPlugins", api.listCustomPlugins)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.ListCustomPluginsResponse.wrap)
      .provideEnvironment(r)
    def listConnectors(request: ListConnectorsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ConnectorSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest,
      ConnectorSummary,
      ListConnectorsPublisher
    ]("listConnectors", api.listConnectorsPaginator, _.connectors())(
      request.buildAwsValue()
    ).map(item => zio.aws.kafkaconnect.model.ConnectorSummary.wrap(item))
      .provideEnvironment(r)
    def listConnectorsPaginated(request: ListConnectorsRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.ListConnectorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest,
      ListConnectorsResponse
    ]("listConnectors", api.listConnectors)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.ListConnectorsResponse.wrap)
      .provideEnvironment(r)
    def describeCustomPlugin(request: DescribeCustomPluginRequest): IO[
      AwsError,
      zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginRequest,
      DescribeCustomPluginResponse
    ]("describeCustomPlugin", api.describeCustomPlugin)(request.buildAwsValue())
      .map(zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteCustomPlugin(request: DeleteCustomPluginRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomPlugin(request))
  def updateConnector(request: UpdateConnectorRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.UpdateConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnector(request))
  def createCustomPlugin(request: CreateCustomPluginRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.CreateCustomPluginResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomPlugin(request))
  def deleteConnector(request: DeleteConnectorRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.DeleteConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnector(request))
  def createConnector(request: CreateConnectorRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.CreateConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnector(request))
  def describeConnector(request: DescribeConnectorRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.DescribeConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnector(request))
  def listWorkerConfigurations(
      request: ListWorkerConfigurationsRequest
  ): ZStream[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.WorkerConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkerConfigurations(request))
  def listWorkerConfigurationsPaginated(
      request: ListWorkerConfigurationsRequest
  ): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkerConfigurationsPaginated(request))
  def createWorkerConfiguration(request: CreateWorkerConfigurationRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkerConfiguration(request))
  def describeWorkerConfiguration(
      request: DescribeWorkerConfigurationRequest
  ): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkerConfiguration(request))
  def listCustomPlugins(
      request: ListCustomPluginsRequest
  ): ZStream[zio.aws.kafkaconnect.KafkaConnect, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listCustomPlugins(request))
  def listCustomPluginsPaginated(request: ListCustomPluginsRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.ListCustomPluginsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomPluginsPaginated(request))
  def listConnectors(request: ListConnectorsRequest): ZStream[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.ConnectorSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listConnectors(request))
  def listConnectorsPaginated(request: ListConnectorsRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.ListConnectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConnectorsPaginated(request))
  def describeCustomPlugin(request: DescribeCustomPluginRequest): ZIO[
    zio.aws.kafkaconnect.KafkaConnect,
    AwsError,
    zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomPlugin(request))
}
