package zio.aws.kafkaconnect
import zio.aws.kafkaconnect.model.CustomPluginSummary.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.kafkaconnect.model.{
  UpdateConnectorRequest,
  ListWorkerConfigurationsRequest,
  DescribeWorkerConfigurationRequest,
  CreateWorkerConfigurationRequest,
  DescribeConnectorRequest,
  DescribeCustomPluginRequest,
  DeleteCustomPluginRequest,
  DeleteConnectorRequest,
  ListConnectorsRequest,
  CreateCustomPluginRequest,
  ListCustomPluginsRequest,
  CreateConnectorRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectAsyncClient
import zio.stream.ZStream
object KafkaConnectMock extends Mock[KafkaConnect] {
  object DeleteCustomPlugin
      extends Effect[
        DeleteCustomPluginRequest,
        AwsError,
        zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.ReadOnly
      ]
  object UpdateConnector
      extends Effect[
        UpdateConnectorRequest,
        AwsError,
        zio.aws.kafkaconnect.model.UpdateConnectorResponse.ReadOnly
      ]
  object CreateCustomPlugin
      extends Effect[
        CreateCustomPluginRequest,
        AwsError,
        zio.aws.kafkaconnect.model.CreateCustomPluginResponse.ReadOnly
      ]
  object DeleteConnector
      extends Effect[
        DeleteConnectorRequest,
        AwsError,
        zio.aws.kafkaconnect.model.DeleteConnectorResponse.ReadOnly
      ]
  object CreateConnector
      extends Effect[
        CreateConnectorRequest,
        AwsError,
        zio.aws.kafkaconnect.model.CreateConnectorResponse.ReadOnly
      ]
  object DescribeConnector
      extends Effect[
        DescribeConnectorRequest,
        AwsError,
        zio.aws.kafkaconnect.model.DescribeConnectorResponse.ReadOnly
      ]
  object ListWorkerConfigurations
      extends Stream[
        ListWorkerConfigurationsRequest,
        AwsError,
        zio.aws.kafkaconnect.model.WorkerConfigurationSummary.ReadOnly
      ]
  object ListWorkerConfigurationsPaginated
      extends Effect[
        ListWorkerConfigurationsRequest,
        AwsError,
        zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.ReadOnly
      ]
  object CreateWorkerConfiguration
      extends Effect[
        CreateWorkerConfigurationRequest,
        AwsError,
        zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.ReadOnly
      ]
  object DescribeWorkerConfiguration
      extends Effect[
        DescribeWorkerConfigurationRequest,
        AwsError,
        zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.ReadOnly
      ]
  object ListCustomPlugins
      extends Stream[ListCustomPluginsRequest, AwsError, ReadOnly]
  object ListCustomPluginsPaginated
      extends Effect[
        ListCustomPluginsRequest,
        AwsError,
        zio.aws.kafkaconnect.model.ListCustomPluginsResponse.ReadOnly
      ]
  object ListConnectors
      extends Stream[
        ListConnectorsRequest,
        AwsError,
        zio.aws.kafkaconnect.model.ConnectorSummary.ReadOnly
      ]
  object ListConnectorsPaginated
      extends Effect[
        ListConnectorsRequest,
        AwsError,
        zio.aws.kafkaconnect.model.ListConnectorsResponse.ReadOnly
      ]
  object DescribeCustomPlugin
      extends Effect[
        DescribeCustomPluginRequest,
        AwsError,
        zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, KafkaConnect] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, KafkaConnect] { rts =>
        zio.ZIO.succeed {
          new KafkaConnect {
            val api: KafkaConnectAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): KafkaConnect = this
            def deleteCustomPlugin(request: DeleteCustomPluginRequest): IO[
              AwsError,
              zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.ReadOnly
            ] = proxy(DeleteCustomPlugin, request)
            def updateConnector(request: UpdateConnectorRequest): IO[
              AwsError,
              zio.aws.kafkaconnect.model.UpdateConnectorResponse.ReadOnly
            ] = proxy(UpdateConnector, request)
            def createCustomPlugin(request: CreateCustomPluginRequest): IO[
              AwsError,
              zio.aws.kafkaconnect.model.CreateCustomPluginResponse.ReadOnly
            ] = proxy(CreateCustomPlugin, request)
            def deleteConnector(request: DeleteConnectorRequest): IO[
              AwsError,
              zio.aws.kafkaconnect.model.DeleteConnectorResponse.ReadOnly
            ] = proxy(DeleteConnector, request)
            def createConnector(request: CreateConnectorRequest): IO[
              AwsError,
              zio.aws.kafkaconnect.model.CreateConnectorResponse.ReadOnly
            ] = proxy(CreateConnector, request)
            def describeConnector(request: DescribeConnectorRequest): IO[
              AwsError,
              zio.aws.kafkaconnect.model.DescribeConnectorResponse.ReadOnly
            ] = proxy(DescribeConnector, request)
            def listWorkerConfigurations(
                request: ListWorkerConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kafkaconnect.model.WorkerConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkerConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkerConfigurationsPaginated(
                request: ListWorkerConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.ReadOnly
            ] = proxy(ListWorkerConfigurationsPaginated, request)
            def createWorkerConfiguration(
                request: CreateWorkerConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.ReadOnly
            ] = proxy(CreateWorkerConfiguration, request)
            def describeWorkerConfiguration(
                request: DescribeWorkerConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.ReadOnly
            ] = proxy(DescribeWorkerConfiguration, request)
            def listCustomPlugins(
                request: ListCustomPluginsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListCustomPlugins, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listCustomPluginsPaginated(
                request: ListCustomPluginsRequest
            ): IO[
              AwsError,
              zio.aws.kafkaconnect.model.ListCustomPluginsResponse.ReadOnly
            ] = proxy(ListCustomPluginsPaginated, request)
            def listConnectors(request: ListConnectorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kafkaconnect.model.ConnectorSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConnectors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConnectorsPaginated(request: ListConnectorsRequest): IO[
              AwsError,
              zio.aws.kafkaconnect.model.ListConnectorsResponse.ReadOnly
            ] = proxy(ListConnectorsPaginated, request)
            def describeCustomPlugin(request: DescribeCustomPluginRequest): IO[
              AwsError,
              zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.ReadOnly
            ] = proxy(DescribeCustomPlugin, request)
          }
        }
      }
    }
  }
}
