package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ApacheKafkaCluster(
    bootstrapServers: __string,
    vpc: zio.aws.kafkaconnect.model.Vpc
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaCluster = {
    import ApacheKafkaCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaCluster
      .builder()
      .bootstrapServers(bootstrapServers: java.lang.String)
      .vpc(vpc.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ApacheKafkaCluster.ReadOnly =
    zio.aws.kafkaconnect.model.ApacheKafkaCluster.wrap(buildAwsValue())
}
object ApacheKafkaCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ApacheKafkaCluster =
      zio.aws.kafkaconnect.model
        .ApacheKafkaCluster(bootstrapServers, vpc.asEditable)
    def bootstrapServers: __string
    def vpc: zio.aws.kafkaconnect.model.Vpc.ReadOnly
    def getBootstrapServers: ZIO[Any, Nothing, __string] =
      ZIO.succeed(bootstrapServers)
    def getVpc: ZIO[Any, Nothing, zio.aws.kafkaconnect.model.Vpc.ReadOnly] =
      ZIO.succeed(vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaCluster
  ) extends zio.aws.kafkaconnect.model.ApacheKafkaCluster.ReadOnly {
    override val bootstrapServers: __string = impl.bootstrapServers(): __string
    override val vpc: zio.aws.kafkaconnect.model.Vpc.ReadOnly =
      zio.aws.kafkaconnect.model.Vpc.wrap(impl.vpc())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaCluster
  ): zio.aws.kafkaconnect.model.ApacheKafkaCluster.ReadOnly = new Wrapper(impl)
}
