package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{
  __integerMin1Max8,
  __integerMin1Max10
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AutoScaling(
    maxWorkerCount: __integerMin1Max10,
    mcuCount: __integerMin1Max8,
    minWorkerCount: __integerMin1Max10,
    scaleInPolicy: Optional[zio.aws.kafkaconnect.model.ScaleInPolicy] =
      Optional.Absent,
    scaleOutPolicy: Optional[zio.aws.kafkaconnect.model.ScaleOutPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.AutoScaling = {
    import AutoScaling.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.AutoScaling
      .builder()
      .maxWorkerCount(maxWorkerCount: Integer)
      .mcuCount(mcuCount: Integer)
      .minWorkerCount(minWorkerCount: Integer)
      .optionallyWith(scaleInPolicy.map(value => value.buildAwsValue()))(
        _.scaleInPolicy
      )
      .optionallyWith(scaleOutPolicy.map(value => value.buildAwsValue()))(
        _.scaleOutPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.AutoScaling.ReadOnly =
    zio.aws.kafkaconnect.model.AutoScaling.wrap(buildAwsValue())
}
object AutoScaling {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.AutoScaling
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.AutoScaling =
      zio.aws.kafkaconnect.model.AutoScaling(
        maxWorkerCount,
        mcuCount,
        minWorkerCount,
        scaleInPolicy.map(value => value.asEditable),
        scaleOutPolicy.map(value => value.asEditable)
      )
    def maxWorkerCount: __integerMin1Max10
    def mcuCount: __integerMin1Max8
    def minWorkerCount: __integerMin1Max10
    def scaleInPolicy
        : Optional[zio.aws.kafkaconnect.model.ScaleInPolicy.ReadOnly]
    def scaleOutPolicy
        : Optional[zio.aws.kafkaconnect.model.ScaleOutPolicy.ReadOnly]
    def getMaxWorkerCount: ZIO[Any, Nothing, __integerMin1Max10] =
      ZIO.succeed(maxWorkerCount)
    def getMcuCount: ZIO[Any, Nothing, __integerMin1Max8] =
      ZIO.succeed(mcuCount)
    def getMinWorkerCount: ZIO[Any, Nothing, __integerMin1Max10] =
      ZIO.succeed(minWorkerCount)
    def getScaleInPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ScaleInPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("scaleInPolicy", scaleInPolicy)
    def getScaleOutPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ScaleOutPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("scaleOutPolicy", scaleOutPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.AutoScaling
  ) extends zio.aws.kafkaconnect.model.AutoScaling.ReadOnly {
    override val maxWorkerCount: __integerMin1Max10 =
      impl.maxWorkerCount(): __integerMin1Max10
    override val mcuCount: __integerMin1Max8 =
      impl.mcuCount(): __integerMin1Max8
    override val minWorkerCount: __integerMin1Max10 =
      impl.minWorkerCount(): __integerMin1Max10
    override val scaleInPolicy
        : Optional[zio.aws.kafkaconnect.model.ScaleInPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleInPolicy())
        .map(value => zio.aws.kafkaconnect.model.ScaleInPolicy.wrap(value))
    override val scaleOutPolicy
        : Optional[zio.aws.kafkaconnect.model.ScaleOutPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleOutPolicy())
        .map(value => zio.aws.kafkaconnect.model.ScaleOutPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.AutoScaling
  ): zio.aws.kafkaconnect.model.AutoScaling.ReadOnly = new Wrapper(impl)
}
