package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Capacity(
    autoScaling: Optional[zio.aws.kafkaconnect.model.AutoScaling] =
      Optional.Absent,
    provisionedCapacity: Optional[
      zio.aws.kafkaconnect.model.ProvisionedCapacity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.Capacity = {
    import Capacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.Capacity
      .builder()
      .optionallyWith(autoScaling.map(value => value.buildAwsValue()))(
        _.autoScaling
      )
      .optionallyWith(provisionedCapacity.map(value => value.buildAwsValue()))(
        _.provisionedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.Capacity.ReadOnly =
    zio.aws.kafkaconnect.model.Capacity.wrap(buildAwsValue())
}
object Capacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.Capacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.Capacity =
      zio.aws.kafkaconnect.model.Capacity(
        autoScaling.map(value => value.asEditable),
        provisionedCapacity.map(value => value.asEditable)
      )
    def autoScaling: Optional[zio.aws.kafkaconnect.model.AutoScaling.ReadOnly]
    def provisionedCapacity
        : Optional[zio.aws.kafkaconnect.model.ProvisionedCapacity.ReadOnly]
    def getAutoScaling
        : ZIO[Any, AwsError, zio.aws.kafkaconnect.model.AutoScaling.ReadOnly] =
      AwsError.unwrapOptionField("autoScaling", autoScaling)
    def getProvisionedCapacity: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ProvisionedCapacity.ReadOnly
    ] = AwsError.unwrapOptionField("provisionedCapacity", provisionedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.Capacity
  ) extends zio.aws.kafkaconnect.model.Capacity.ReadOnly {
    override val autoScaling
        : Optional[zio.aws.kafkaconnect.model.AutoScaling.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScaling())
        .map(value => zio.aws.kafkaconnect.model.AutoScaling.wrap(value))
    override val provisionedCapacity
        : Optional[zio.aws.kafkaconnect.model.ProvisionedCapacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedCapacity())
        .map(value =>
          zio.aws.kafkaconnect.model.ProvisionedCapacity.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.Capacity
  ): zio.aws.kafkaconnect.model.Capacity.ReadOnly = new Wrapper(impl)
}
