package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsLogDeliveryDescription(
    enabled: Optional[__boolean] = Optional.Absent,
    logGroup: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription = {
    import CloudWatchLogsLogDeliveryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(logGroup.map(value => value: java.lang.String))(
        _.logGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription.ReadOnly =
    zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription
      .wrap(buildAwsValue())
}
object CloudWatchLogsLogDeliveryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription =
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription(
        enabled.map(value => value),
        logGroup.map(value => value)
      )
    def enabled: Optional[__boolean]
    def logGroup: Optional[__string]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getLogGroup: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription
  ) extends zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription.ReadOnly {
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val logGroup: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroup())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription
  ): zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription.ReadOnly =
    new Wrapper(impl)
}
