package zio.aws.kafkaconnect.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectorState {
  def unwrap: software.amazon.awssdk.services.kafkaconnect.model.ConnectorState
}
object ConnectorState {
  def wrap(
      value: software.amazon.awssdk.services.kafkaconnect.model.ConnectorState
  ): zio.aws.kafkaconnect.model.ConnectorState = value match {
    case software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kafkaconnect.model.ConnectorState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.ConnectorState =
      software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.kafkaconnect.model.ConnectorState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.ConnectorState =
      software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.RUNNING
  }
  case object CREATING extends zio.aws.kafkaconnect.model.ConnectorState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.ConnectorState =
      software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.CREATING
  }
  case object UPDATING extends zio.aws.kafkaconnect.model.ConnectorState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.ConnectorState =
      software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.UPDATING
  }
  case object DELETING extends zio.aws.kafkaconnect.model.ConnectorState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.ConnectorState =
      software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.DELETING
  }
  case object FAILED extends zio.aws.kafkaconnect.model.ConnectorState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.ConnectorState =
      software.amazon.awssdk.services.kafkaconnect.model.ConnectorState.FAILED
  }
}
