package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters.*
final case class CreateCustomPluginResponse(
    customPluginArn: Optional[__string] = Optional.Absent,
    customPluginState: Optional[zio.aws.kafkaconnect.model.CustomPluginState] =
      Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    revision: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginResponse = {
    import CreateCustomPluginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginResponse
      .builder()
      .optionallyWith(customPluginArn.map(value => value: java.lang.String))(
        _.customPluginArn
      )
      .optionallyWith(customPluginState.map(value => value.unwrap))(
        _.customPluginState
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(revision.map(value => value: java.lang.Long))(_.revision)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CreateCustomPluginResponse.ReadOnly =
    zio.aws.kafkaconnect.model.CreateCustomPluginResponse.wrap(buildAwsValue())
}
object CreateCustomPluginResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CreateCustomPluginResponse =
      zio.aws.kafkaconnect.model.CreateCustomPluginResponse(
        customPluginArn.map(value => value),
        customPluginState.map(value => value),
        name.map(value => value),
        revision.map(value => value)
      )
    def customPluginArn: Optional[__string]
    def customPluginState
        : Optional[zio.aws.kafkaconnect.model.CustomPluginState]
    def name: Optional[__string]
    def revision: Optional[__long]
    def getCustomPluginArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("customPluginArn", customPluginArn)
    def getCustomPluginState
        : ZIO[Any, AwsError, zio.aws.kafkaconnect.model.CustomPluginState] =
      AwsError.unwrapOptionField("customPluginState", customPluginState)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginResponse
  ) extends zio.aws.kafkaconnect.model.CreateCustomPluginResponse.ReadOnly {
    override val customPluginArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.customPluginArn())
      .map(value => value: __string)
    override val customPluginState
        : Optional[zio.aws.kafkaconnect.model.CustomPluginState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customPluginState())
        .map(value => zio.aws.kafkaconnect.model.CustomPluginState.wrap(value))
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val revision: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginResponse
  ): zio.aws.kafkaconnect.model.CreateCustomPluginResponse.ReadOnly =
    new Wrapper(impl)
}
