package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{__string, __timestampIso8601}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateWorkerConfigurationResponse(
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    latestRevision: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary
    ] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    workerConfigurationArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationResponse = {
    import CreateWorkerConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationResponse
      .builder()
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(latestRevision.map(value => value.buildAwsValue()))(
        _.latestRevision
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        workerConfigurationArn.map(value => value: java.lang.String)
      )(_.workerConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.ReadOnly =
    zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateWorkerConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse =
      zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse(
        creationTime.map(value => value),
        latestRevision.map(value => value.asEditable),
        name.map(value => value),
        workerConfigurationArn.map(value => value)
      )
    def creationTime: Optional[__timestampIso8601]
    def latestRevision: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary.ReadOnly
    ]
    def name: Optional[__string]
    def workerConfigurationArn: Optional[__string]
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLatestRevision: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("latestRevision", latestRevision)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getWorkerConfigurationArn: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("workerConfigurationArn", workerConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationResponse
  ) extends zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.ReadOnly {
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val latestRevision: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRevision())
      .map(value =>
        zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary
          .wrap(value)
      )
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val workerConfigurationArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workerConfigurationArn())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationResponse
  ): zio.aws.kafkaconnect.model.CreateWorkerConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
