package zio.aws.kafkaconnect.model
import scala.jdk.CollectionConverters.*
sealed trait CustomPluginContentType {
  def unwrap: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType
}
object CustomPluginContentType {
  def wrap(
      value: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType
  ): zio.aws.kafkaconnect.model.CustomPluginContentType = value match {
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType.JAR =>
      val r = JAR
      r
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType.ZIP =>
      val r = ZIP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kafkaconnect.model.CustomPluginContentType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object JAR extends zio.aws.kafkaconnect.model.CustomPluginContentType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType.JAR
  }
  case object ZIP extends zio.aws.kafkaconnect.model.CustomPluginContentType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType.ZIP
  }
}
