package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters.*
final case class CustomPluginFileDescription(
    fileMd5: Optional[__string] = Optional.Absent,
    fileSize: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginFileDescription = {
    import CustomPluginFileDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginFileDescription
      .builder()
      .optionallyWith(fileMd5.map(value => value: java.lang.String))(_.fileMd5)
      .optionallyWith(fileSize.map(value => value: java.lang.Long))(_.fileSize)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CustomPluginFileDescription.ReadOnly =
    zio.aws.kafkaconnect.model.CustomPluginFileDescription.wrap(buildAwsValue())
}
object CustomPluginFileDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginFileDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CustomPluginFileDescription =
      zio.aws.kafkaconnect.model.CustomPluginFileDescription(
        fileMd5.map(value => value),
        fileSize.map(value => value)
      )
    def fileMd5: Optional[__string]
    def fileSize: Optional[__long]
    def getFileMd5: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fileMd5", fileMd5)
    def getFileSize: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("fileSize", fileSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginFileDescription
  ) extends zio.aws.kafkaconnect.model.CustomPluginFileDescription.ReadOnly {
    override val fileMd5: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.fileMd5())
      .map(value => value: __string)
    override val fileSize: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSize())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginFileDescription
  ): zio.aws.kafkaconnect.model.CustomPluginFileDescription.ReadOnly =
    new Wrapper(impl)
}
