package zio.aws.kafkaconnect.model
import scala.jdk.CollectionConverters.*
sealed trait CustomPluginState {
  def unwrap
      : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState
}
object CustomPluginState {
  def wrap(
      value: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState
  ): zio.aws.kafkaconnect.model.CustomPluginState = value match {
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kafkaconnect.model.CustomPluginState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kafkaconnect.model.CustomPluginState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.CREATING
  }
  case object CREATE_FAILED
      extends zio.aws.kafkaconnect.model.CustomPluginState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.CREATE_FAILED
  }
  case object ACTIVE extends zio.aws.kafkaconnect.model.CustomPluginState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.ACTIVE
  }
  case object UPDATING extends zio.aws.kafkaconnect.model.CustomPluginState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.UPDATING
  }
  case object UPDATE_FAILED
      extends zio.aws.kafkaconnect.model.CustomPluginState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.UPDATE_FAILED
  }
  case object DELETING extends zio.aws.kafkaconnect.model.CustomPluginState {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState =
      software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState.DELETING
  }
}
