package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DeleteCustomPluginResponse(
    customPluginArn: Optional[__string] = Optional.Absent,
    customPluginState: Optional[zio.aws.kafkaconnect.model.CustomPluginState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginResponse = {
    import DeleteCustomPluginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginResponse
      .builder()
      .optionallyWith(customPluginArn.map(value => value: java.lang.String))(
        _.customPluginArn
      )
      .optionallyWith(customPluginState.map(value => value.unwrap))(
        _.customPluginState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.ReadOnly =
    zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.wrap(buildAwsValue())
}
object DeleteCustomPluginResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.DeleteCustomPluginResponse =
      zio.aws.kafkaconnect.model.DeleteCustomPluginResponse(
        customPluginArn.map(value => value),
        customPluginState.map(value => value)
      )
    def customPluginArn: Optional[__string]
    def customPluginState
        : Optional[zio.aws.kafkaconnect.model.CustomPluginState]
    def getCustomPluginArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("customPluginArn", customPluginArn)
    def getCustomPluginState
        : ZIO[Any, AwsError, zio.aws.kafkaconnect.model.CustomPluginState] =
      AwsError.unwrapOptionField("customPluginState", customPluginState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginResponse
  ) extends zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.ReadOnly {
    override val customPluginArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.customPluginArn())
      .map(value => value: __string)
    override val customPluginState
        : Optional[zio.aws.kafkaconnect.model.CustomPluginState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customPluginState())
        .map(value => zio.aws.kafkaconnect.model.CustomPluginState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginResponse
  ): zio.aws.kafkaconnect.model.DeleteCustomPluginResponse.ReadOnly =
    new Wrapper(impl)
}
