package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KafkaCluster(
    apacheKafkaCluster: zio.aws.kafkaconnect.model.ApacheKafkaCluster
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.KafkaCluster = {
    import KafkaCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.KafkaCluster
      .builder()
      .apacheKafkaCluster(apacheKafkaCluster.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.KafkaCluster.ReadOnly =
    zio.aws.kafkaconnect.model.KafkaCluster.wrap(buildAwsValue())
}
object KafkaCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.KafkaCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.KafkaCluster =
      zio.aws.kafkaconnect.model.KafkaCluster(apacheKafkaCluster.asEditable)
    def apacheKafkaCluster
        : zio.aws.kafkaconnect.model.ApacheKafkaCluster.ReadOnly
    def getApacheKafkaCluster: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.ApacheKafkaCluster.ReadOnly
    ] = ZIO.succeed(apacheKafkaCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaCluster
  ) extends zio.aws.kafkaconnect.model.KafkaCluster.ReadOnly {
    override val apacheKafkaCluster
        : zio.aws.kafkaconnect.model.ApacheKafkaCluster.ReadOnly =
      zio.aws.kafkaconnect.model.ApacheKafkaCluster
        .wrap(impl.apacheKafkaCluster())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaCluster
  ): zio.aws.kafkaconnect.model.KafkaCluster.ReadOnly = new Wrapper(impl)
}
