package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KafkaClusterClientAuthentication(
    authenticationType: zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthentication = {
    import KafkaClusterClientAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthentication
      .builder()
      .authenticationType(authenticationType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication.ReadOnly =
    zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication
      .wrap(buildAwsValue())
}
object KafkaClusterClientAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication =
      zio.aws.kafkaconnect.model
        .KafkaClusterClientAuthentication(authenticationType)
    def authenticationType
        : zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
    def getAuthenticationType: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
    ] = ZIO.succeed(authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthentication
  ) extends zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication.ReadOnly {
    override val authenticationType
        : zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType =
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
        .wrap(impl.authenticationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthentication
  ): zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication.ReadOnly =
    new Wrapper(impl)
}
