package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KafkaClusterDescription(
    apacheKafkaCluster: Optional[
      zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterDescription = {
    import KafkaClusterDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterDescription
      .builder()
      .optionallyWith(apacheKafkaCluster.map(value => value.buildAwsValue()))(
        _.apacheKafkaCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.KafkaClusterDescription.ReadOnly =
    zio.aws.kafkaconnect.model.KafkaClusterDescription.wrap(buildAwsValue())
}
object KafkaClusterDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.KafkaClusterDescription =
      zio.aws.kafkaconnect.model.KafkaClusterDescription(
        apacheKafkaCluster.map(value => value.asEditable)
      )
    def apacheKafkaCluster: Optional[
      zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription.ReadOnly
    ]
    def getApacheKafkaCluster: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription.ReadOnly
    ] = AwsError.unwrapOptionField("apacheKafkaCluster", apacheKafkaCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterDescription
  ) extends zio.aws.kafkaconnect.model.KafkaClusterDescription.ReadOnly {
    override val apacheKafkaCluster: Optional[
      zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.apacheKafkaCluster())
      .map(value =>
        zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterDescription
  ): zio.aws.kafkaconnect.model.KafkaClusterDescription.ReadOnly = new Wrapper(
    impl
  )
}
