package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KafkaClusterEncryptionInTransit(
    encryptionType: zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransit = {
    import KafkaClusterEncryptionInTransit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransit
      .builder()
      .encryptionType(encryptionType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit.ReadOnly =
    zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit
      .wrap(buildAwsValue())
}
object KafkaClusterEncryptionInTransit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit =
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit(encryptionType)
    def encryptionType
        : zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
    def getEncryptionType: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
    ] = ZIO.succeed(encryptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransit
  ) extends zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit.ReadOnly {
    override val encryptionType
        : zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType =
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitType
        .wrap(impl.encryptionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransit
  ): zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit.ReadOnly =
    new Wrapper(impl)
}
