package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{MaxResults, __string}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListConnectorsRequest(
    connectorNamePrefix: Optional[__string] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest = {
    import ListConnectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest
      .builder()
      .optionallyWith(
        connectorNamePrefix.map(value => value: java.lang.String)
      )(_.connectorNamePrefix)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ListConnectorsRequest.ReadOnly =
    zio.aws.kafkaconnect.model.ListConnectorsRequest.wrap(buildAwsValue())
}
object ListConnectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ListConnectorsRequest =
      zio.aws.kafkaconnect.model.ListConnectorsRequest(
        connectorNamePrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def connectorNamePrefix: Optional[__string]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getConnectorNamePrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectorNamePrefix", connectorNamePrefix)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest
  ) extends zio.aws.kafkaconnect.model.ListConnectorsRequest.ReadOnly {
    override val connectorNamePrefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorNamePrefix())
      .map(value => value: __string)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.kafkaconnect.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest
  ): zio.aws.kafkaconnect.model.ListConnectorsRequest.ReadOnly = new Wrapper(
    impl
  )
}
