package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListConnectorsResponse(
    connectors: Optional[
      Iterable[zio.aws.kafkaconnect.model.ConnectorSummary]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse = {
    import ListConnectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse
      .builder()
      .optionallyWith(
        connectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectors)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ListConnectorsResponse.ReadOnly =
    zio.aws.kafkaconnect.model.ListConnectorsResponse.wrap(buildAwsValue())
}
object ListConnectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ListConnectorsResponse =
      zio.aws.kafkaconnect.model.ListConnectorsResponse(
        connectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectors
        : Optional[List[zio.aws.kafkaconnect.model.ConnectorSummary.ReadOnly]]
    def nextToken: Optional[__string]
    def getConnectors: ZIO[Any, AwsError, List[
      zio.aws.kafkaconnect.model.ConnectorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("connectors", connectors)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse
  ) extends zio.aws.kafkaconnect.model.ListConnectorsResponse.ReadOnly {
    override val connectors
        : Optional[List[zio.aws.kafkaconnect.model.ConnectorSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafkaconnect.model.ConnectorSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse
  ): zio.aws.kafkaconnect.model.ListConnectorsResponse.ReadOnly = new Wrapper(
    impl
  )
}
