package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListCustomPluginsResponse(
    customPlugins: Optional[
      Iterable[zio.aws.kafkaconnect.model.CustomPluginSummary]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse = {
    import ListCustomPluginsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse
      .builder()
      .optionallyWith(
        customPlugins.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customPlugins)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.ListCustomPluginsResponse.ReadOnly =
    zio.aws.kafkaconnect.model.ListCustomPluginsResponse.wrap(buildAwsValue())
}
object ListCustomPluginsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ListCustomPluginsResponse =
      zio.aws.kafkaconnect.model.ListCustomPluginsResponse(
        customPlugins.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def customPlugins: Optional[
      List[zio.aws.kafkaconnect.model.CustomPluginSummary.ReadOnly]
    ]
    def nextToken: Optional[__string]
    def getCustomPlugins: ZIO[Any, AwsError, List[
      zio.aws.kafkaconnect.model.CustomPluginSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("customPlugins", customPlugins)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse
  ) extends zio.aws.kafkaconnect.model.ListCustomPluginsResponse.ReadOnly {
    override val customPlugins: Optional[
      List[zio.aws.kafkaconnect.model.CustomPluginSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customPlugins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafkaconnect.model.CustomPluginSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse
  ): zio.aws.kafkaconnect.model.ListCustomPluginsResponse.ReadOnly =
    new Wrapper(impl)
}
