package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{__string, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkerConfigurationsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest = {
    import ListWorkerConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.ListWorkerConfigurationsRequest.ReadOnly =
    zio.aws.kafkaconnect.model.ListWorkerConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListWorkerConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ListWorkerConfigurationsRequest =
      zio.aws.kafkaconnect.model.ListWorkerConfigurationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest
  ) extends zio.aws.kafkaconnect.model.ListWorkerConfigurationsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.kafkaconnect.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest
  ): zio.aws.kafkaconnect.model.ListWorkerConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
