package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListWorkerConfigurationsResponse(
    nextToken: Optional[__string] = Optional.Absent,
    workerConfigurations: Optional[
      Iterable[zio.aws.kafkaconnect.model.WorkerConfigurationSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse = {
    import ListWorkerConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        workerConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workerConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.ReadOnly =
    zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListWorkerConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse =
      zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse(
        nextToken.map(value => value),
        workerConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def workerConfigurations: Optional[
      List[zio.aws.kafkaconnect.model.WorkerConfigurationSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkerConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kafkaconnect.model.WorkerConfigurationSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("workerConfigurations", workerConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse
  ) extends zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val workerConfigurations: Optional[
      List[zio.aws.kafkaconnect.model.WorkerConfigurationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workerConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafkaconnect.model.WorkerConfigurationSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse
  ): zio.aws.kafkaconnect.model.ListWorkerConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
