package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LogDelivery(
    workerLogDelivery: zio.aws.kafkaconnect.model.WorkerLogDelivery
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.LogDelivery = {
    import LogDelivery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.LogDelivery
      .builder()
      .workerLogDelivery(workerLogDelivery.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.LogDelivery.ReadOnly =
    zio.aws.kafkaconnect.model.LogDelivery.wrap(buildAwsValue())
}
object LogDelivery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.LogDelivery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.LogDelivery =
      zio.aws.kafkaconnect.model.LogDelivery(workerLogDelivery.asEditable)
    def workerLogDelivery: zio.aws.kafkaconnect.model.WorkerLogDelivery.ReadOnly
    def getWorkerLogDelivery: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.WorkerLogDelivery.ReadOnly
    ] = ZIO.succeed(workerLogDelivery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.LogDelivery
  ) extends zio.aws.kafkaconnect.model.LogDelivery.ReadOnly {
    override val workerLogDelivery
        : zio.aws.kafkaconnect.model.WorkerLogDelivery.ReadOnly =
      zio.aws.kafkaconnect.model.WorkerLogDelivery
        .wrap(impl.workerLogDelivery())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.LogDelivery
  ): zio.aws.kafkaconnect.model.LogDelivery.ReadOnly = new Wrapper(impl)
}
