package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogDeliveryDescription(
    workerLogDelivery: Optional[
      zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.LogDeliveryDescription = {
    import LogDeliveryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.LogDeliveryDescription
      .builder()
      .optionallyWith(workerLogDelivery.map(value => value.buildAwsValue()))(
        _.workerLogDelivery
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.LogDeliveryDescription.ReadOnly =
    zio.aws.kafkaconnect.model.LogDeliveryDescription.wrap(buildAwsValue())
}
object LogDeliveryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.LogDeliveryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.LogDeliveryDescription =
      zio.aws.kafkaconnect.model.LogDeliveryDescription(
        workerLogDelivery.map(value => value.asEditable)
      )
    def workerLogDelivery: Optional[
      zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription.ReadOnly
    ]
    def getWorkerLogDelivery: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("workerLogDelivery", workerLogDelivery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.LogDeliveryDescription
  ) extends zio.aws.kafkaconnect.model.LogDeliveryDescription.ReadOnly {
    override val workerLogDelivery: Optional[
      zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workerLogDelivery())
      .map(value =>
        zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.LogDeliveryDescription
  ): zio.aws.kafkaconnect.model.LogDeliveryDescription.ReadOnly = new Wrapper(
    impl
  )
}
