package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PluginDescription(
    customPlugin: Optional[zio.aws.kafkaconnect.model.CustomPluginDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.PluginDescription = {
    import PluginDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.PluginDescription
      .builder()
      .optionallyWith(customPlugin.map(value => value.buildAwsValue()))(
        _.customPlugin
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.PluginDescription.ReadOnly =
    zio.aws.kafkaconnect.model.PluginDescription.wrap(buildAwsValue())
}
object PluginDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.PluginDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.PluginDescription =
      zio.aws.kafkaconnect.model
        .PluginDescription(customPlugin.map(value => value.asEditable))
    def customPlugin
        : Optional[zio.aws.kafkaconnect.model.CustomPluginDescription.ReadOnly]
    def getCustomPlugin: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.CustomPluginDescription.ReadOnly
    ] = AwsError.unwrapOptionField("customPlugin", customPlugin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.PluginDescription
  ) extends zio.aws.kafkaconnect.model.PluginDescription.ReadOnly {
    override val customPlugin: Optional[
      zio.aws.kafkaconnect.model.CustomPluginDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customPlugin())
      .map(value =>
        zio.aws.kafkaconnect.model.CustomPluginDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.PluginDescription
  ): zio.aws.kafkaconnect.model.PluginDescription.ReadOnly = new Wrapper(impl)
}
