package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.__integer
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ProvisionedCapacityDescription(
    mcuCount: Optional[__integer] = Optional.Absent,
    workerCount: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityDescription = {
    import ProvisionedCapacityDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityDescription
      .builder()
      .optionallyWith(mcuCount.map(value => value: Integer))(_.mcuCount)
      .optionallyWith(workerCount.map(value => value: Integer))(_.workerCount)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.ProvisionedCapacityDescription.ReadOnly =
    zio.aws.kafkaconnect.model.ProvisionedCapacityDescription
      .wrap(buildAwsValue())
}
object ProvisionedCapacityDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ProvisionedCapacityDescription =
      zio.aws.kafkaconnect.model.ProvisionedCapacityDescription(
        mcuCount.map(value => value),
        workerCount.map(value => value)
      )
    def mcuCount: Optional[__integer]
    def workerCount: Optional[__integer]
    def getMcuCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("mcuCount", mcuCount)
    def getWorkerCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("workerCount", workerCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityDescription
  ) extends zio.aws.kafkaconnect.model.ProvisionedCapacityDescription.ReadOnly {
    override val mcuCount: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.mcuCount())
      .map(value => value: __integer)
    override val workerCount: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.workerCount())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityDescription
  ): zio.aws.kafkaconnect.model.ProvisionedCapacityDescription.ReadOnly =
    new Wrapper(impl)
}
