package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucketArn: __string,
    fileKey: __string,
    objectVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.S3Location
      .builder()
      .bucketArn(bucketArn: java.lang.String)
      .fileKey(fileKey: java.lang.String)
      .optionallyWith(objectVersion.map(value => value: java.lang.String))(
        _.objectVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.S3Location.ReadOnly =
    zio.aws.kafkaconnect.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.S3Location =
      zio.aws.kafkaconnect.model
        .S3Location(bucketArn, fileKey, objectVersion.map(value => value))
    def bucketArn: __string
    def fileKey: __string
    def objectVersion: Optional[__string]
    def getBucketArn: ZIO[Any, Nothing, __string] = ZIO.succeed(bucketArn)
    def getFileKey: ZIO[Any, Nothing, __string] = ZIO.succeed(fileKey)
    def getObjectVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("objectVersion", objectVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.S3Location
  ) extends zio.aws.kafkaconnect.model.S3Location.ReadOnly {
    override val bucketArn: __string = impl.bucketArn(): __string
    override val fileKey: __string = impl.fileKey(): __string
    override val objectVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.objectVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.S3Location
  ): zio.aws.kafkaconnect.model.S3Location.ReadOnly = new Wrapper(impl)
}
