package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class S3LogDelivery(
    bucket: Optional[__string] = Optional.Absent,
    enabled: __boolean,
    prefix: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.S3LogDelivery = {
    import S3LogDelivery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.S3LogDelivery
      .builder()
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.S3LogDelivery.ReadOnly =
    zio.aws.kafkaconnect.model.S3LogDelivery.wrap(buildAwsValue())
}
object S3LogDelivery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.S3LogDelivery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.S3LogDelivery =
      zio.aws.kafkaconnect.model.S3LogDelivery(
        bucket.map(value => value),
        enabled,
        prefix.map(value => value)
      )
    def bucket: Optional[__string]
    def enabled: __boolean
    def prefix: Optional[__string]
    def getBucket: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getEnabled: ZIO[Any, Nothing, __boolean] = ZIO.succeed(enabled)
    def getPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.S3LogDelivery
  ) extends zio.aws.kafkaconnect.model.S3LogDelivery.ReadOnly {
    override val bucket: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => value: __string)
    override val enabled: __boolean = impl.enabled(): __boolean
    override val prefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.S3LogDelivery
  ): zio.aws.kafkaconnect.model.S3LogDelivery.ReadOnly = new Wrapper(impl)
}
