package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class S3LogDeliveryDescription(
    bucket: Optional[__string] = Optional.Absent,
    enabled: Optional[__boolean] = Optional.Absent,
    prefix: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.S3LogDeliveryDescription = {
    import S3LogDeliveryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.S3LogDeliveryDescription
      .builder()
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.S3LogDeliveryDescription.ReadOnly =
    zio.aws.kafkaconnect.model.S3LogDeliveryDescription.wrap(buildAwsValue())
}
object S3LogDeliveryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.S3LogDeliveryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.S3LogDeliveryDescription =
      zio.aws.kafkaconnect.model.S3LogDeliveryDescription(
        bucket.map(value => value),
        enabled.map(value => value),
        prefix.map(value => value)
      )
    def bucket: Optional[__string]
    def enabled: Optional[__boolean]
    def prefix: Optional[__string]
    def getBucket: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.S3LogDeliveryDescription
  ) extends zio.aws.kafkaconnect.model.S3LogDeliveryDescription.ReadOnly {
    override val bucket: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => value: __string)
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val prefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.S3LogDeliveryDescription
  ): zio.aws.kafkaconnect.model.S3LogDeliveryDescription.ReadOnly = new Wrapper(
    impl
  )
}
