package zio.aws.kafkaconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.__integerMin1Max100
import scala.jdk.CollectionConverters.*
final case class ScaleInPolicy(cpuUtilizationPercentage: __integerMin1Max100) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicy = {
    import ScaleInPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicy
      .builder()
      .cpuUtilizationPercentage(cpuUtilizationPercentage: Integer)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ScaleInPolicy.ReadOnly =
    zio.aws.kafkaconnect.model.ScaleInPolicy.wrap(buildAwsValue())
}
object ScaleInPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ScaleInPolicy =
      zio.aws.kafkaconnect.model.ScaleInPolicy(cpuUtilizationPercentage)
    def cpuUtilizationPercentage: __integerMin1Max100
    def getCpuUtilizationPercentage: ZIO[Any, Nothing, __integerMin1Max100] =
      ZIO.succeed(cpuUtilizationPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicy
  ) extends zio.aws.kafkaconnect.model.ScaleInPolicy.ReadOnly {
    override val cpuUtilizationPercentage: __integerMin1Max100 =
      impl.cpuUtilizationPercentage(): __integerMin1Max100
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicy
  ): zio.aws.kafkaconnect.model.ScaleInPolicy.ReadOnly = new Wrapper(impl)
}
