package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.__integer
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ScaleInPolicyDescription(
    cpuUtilizationPercentage: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyDescription = {
    import ScaleInPolicyDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyDescription
      .builder()
      .optionallyWith(cpuUtilizationPercentage.map(value => value: Integer))(
        _.cpuUtilizationPercentage
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ScaleInPolicyDescription.ReadOnly =
    zio.aws.kafkaconnect.model.ScaleInPolicyDescription.wrap(buildAwsValue())
}
object ScaleInPolicyDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ScaleInPolicyDescription =
      zio.aws.kafkaconnect.model
        .ScaleInPolicyDescription(cpuUtilizationPercentage.map(value => value))
    def cpuUtilizationPercentage: Optional[__integer]
    def getCpuUtilizationPercentage: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("cpuUtilizationPercentage", cpuUtilizationPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyDescription
  ) extends zio.aws.kafkaconnect.model.ScaleInPolicyDescription.ReadOnly {
    override val cpuUtilizationPercentage: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuUtilizationPercentage())
        .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyDescription
  ): zio.aws.kafkaconnect.model.ScaleInPolicyDescription.ReadOnly = new Wrapper(
    impl
  )
}
