package zio.aws.kafkaconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.__integerMin1Max100
import scala.jdk.CollectionConverters.*
final case class ScaleOutPolicy(cpuUtilizationPercentage: __integerMin1Max100) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicy = {
    import ScaleOutPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicy
      .builder()
      .cpuUtilizationPercentage(cpuUtilizationPercentage: Integer)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.ScaleOutPolicy.ReadOnly =
    zio.aws.kafkaconnect.model.ScaleOutPolicy.wrap(buildAwsValue())
}
object ScaleOutPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ScaleOutPolicy =
      zio.aws.kafkaconnect.model.ScaleOutPolicy(cpuUtilizationPercentage)
    def cpuUtilizationPercentage: __integerMin1Max100
    def getCpuUtilizationPercentage: ZIO[Any, Nothing, __integerMin1Max100] =
      ZIO.succeed(cpuUtilizationPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicy
  ) extends zio.aws.kafkaconnect.model.ScaleOutPolicy.ReadOnly {
    override val cpuUtilizationPercentage: __integerMin1Max100 =
      impl.cpuUtilizationPercentage(): __integerMin1Max100
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicy
  ): zio.aws.kafkaconnect.model.ScaleOutPolicy.ReadOnly = new Wrapper(impl)
}
