package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class StateDescription(
    code: Optional[__string] = Optional.Absent,
    message: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.StateDescription = {
    import StateDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.StateDescription
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.StateDescription.ReadOnly =
    zio.aws.kafkaconnect.model.StateDescription.wrap(buildAwsValue())
}
object StateDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.StateDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.StateDescription =
      zio.aws.kafkaconnect.model
        .StateDescription(code.map(value => value), message.map(value => value))
    def code: Optional[__string]
    def message: Optional[__string]
    def getCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.StateDescription
  ) extends zio.aws.kafkaconnect.model.StateDescription.ReadOnly {
    override val code: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: __string)
    override val message: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.StateDescription
  ): zio.aws.kafkaconnect.model.StateDescription.ReadOnly = new Wrapper(impl)
}
