package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class Vpc(
    securityGroups: Optional[Iterable[__string]] = Optional.Absent,
    subnets: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.Vpc = {
    import Vpc.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.Vpc
      .builder()
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .subnets(subnets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.Vpc.ReadOnly =
    zio.aws.kafkaconnect.model.Vpc.wrap(buildAwsValue())
}
object Vpc {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafkaconnect.model.Vpc] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.Vpc = zio.aws.kafkaconnect.model
      .Vpc(securityGroups.map(value => value), subnets)
    def securityGroups: Optional[List[__string]]
    def subnets: List[__string]
    def getSecurityGroups: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnets: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.Vpc
  ) extends zio.aws.kafkaconnect.model.Vpc.ReadOnly {
    override val securityGroups: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val subnets: List[__string] = impl
      .subnets()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.Vpc
  ): zio.aws.kafkaconnect.model.Vpc.ReadOnly = new Wrapper(impl)
}
