package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__string, __long}
import scala.jdk.CollectionConverters.*
final case class WorkerConfigurationDescription(
    revision: Optional[__long] = Optional.Absent,
    workerConfigurationArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationDescription = {
    import WorkerConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationDescription
      .builder()
      .optionallyWith(revision.map(value => value: java.lang.Long))(_.revision)
      .optionallyWith(
        workerConfigurationArn.map(value => value: java.lang.String)
      )(_.workerConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.WorkerConfigurationDescription.ReadOnly =
    zio.aws.kafkaconnect.model.WorkerConfigurationDescription
      .wrap(buildAwsValue())
}
object WorkerConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.WorkerConfigurationDescription =
      zio.aws.kafkaconnect.model.WorkerConfigurationDescription(
        revision.map(value => value),
        workerConfigurationArn.map(value => value)
      )
    def revision: Optional[__long]
    def workerConfigurationArn: Optional[__string]
    def getRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("revision", revision)
    def getWorkerConfigurationArn: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("workerConfigurationArn", workerConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationDescription
  ) extends zio.aws.kafkaconnect.model.WorkerConfigurationDescription.ReadOnly {
    override val revision: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: __long)
    override val workerConfigurationArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workerConfigurationArn())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationDescription
  ): zio.aws.kafkaconnect.model.WorkerConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
