package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{
  __long,
  SyntheticWorkerConfigurationRevisionDescription__string,
  __string,
  __timestampIso8601
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class WorkerConfigurationRevisionDescription(
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    propertiesFileContent: Optional[
      SyntheticWorkerConfigurationRevisionDescription__string
    ] = Optional.Absent,
    revision: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionDescription = {
    import WorkerConfigurationRevisionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionDescription
      .builder()
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        propertiesFileContent.map(value =>
          SyntheticWorkerConfigurationRevisionDescription__string.unwrap(
            value
          ): java.lang.String
        )
      )(_.propertiesFileContent)
      .optionallyWith(revision.map(value => value: java.lang.Long))(_.revision)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription.ReadOnly =
    zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription
      .wrap(buildAwsValue())
}
object WorkerConfigurationRevisionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription =
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription(
        creationTime.map(value => value),
        description.map(value => value),
        propertiesFileContent.map(value => value),
        revision.map(value => value)
      )
    def creationTime: Optional[__timestampIso8601]
    def description: Optional[__string]
    def propertiesFileContent
        : Optional[SyntheticWorkerConfigurationRevisionDescription__string]
    def revision: Optional[__long]
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getPropertiesFileContent: ZIO[
      Any,
      AwsError,
      SyntheticWorkerConfigurationRevisionDescription__string
    ] =
      AwsError.unwrapOptionField("propertiesFileContent", propertiesFileContent)
    def getRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionDescription
  ) extends zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription.ReadOnly {
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val propertiesFileContent
        : Optional[SyntheticWorkerConfigurationRevisionDescription__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertiesFileContent())
        .map(value =>
          zio.aws.kafkaconnect.model.primitives
            .SyntheticWorkerConfigurationRevisionDescription__string(value)
        )
    override val revision: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionDescription
  ): zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription.ReadOnly =
    new Wrapper(impl)
}
