package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{
  __long,
  __string,
  __timestampIso8601
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class WorkerConfigurationRevisionSummary(
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    revision: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionSummary = {
    import WorkerConfigurationRevisionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionSummary
      .builder()
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(revision.map(value => value: java.lang.Long))(_.revision)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary.ReadOnly =
    zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary
      .wrap(buildAwsValue())
}
object WorkerConfigurationRevisionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary =
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary(
        creationTime.map(value => value),
        description.map(value => value),
        revision.map(value => value)
      )
    def creationTime: Optional[__timestampIso8601]
    def description: Optional[__string]
    def revision: Optional[__long]
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionSummary
  ) extends zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary.ReadOnly {
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val revision: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionSummary
  ): zio.aws.kafkaconnect.model.WorkerConfigurationRevisionSummary.ReadOnly =
    new Wrapper(impl)
}
