package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkerLogDeliveryDescription(
    cloudWatchLogs: Optional[
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription
    ] = Optional.Absent,
    firehose: Optional[
      zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription
    ] = Optional.Absent,
    s3: Optional[zio.aws.kafkaconnect.model.S3LogDeliveryDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDeliveryDescription = {
    import WorkerLogDeliveryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDeliveryDescription
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(firehose.map(value => value.buildAwsValue()))(_.firehose)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription.ReadOnly =
    zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription
      .wrap(buildAwsValue())
}
object WorkerLogDeliveryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDeliveryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription =
      zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription(
        cloudWatchLogs.map(value => value.asEditable),
        firehose.map(value => value.asEditable),
        s3.map(value => value.asEditable)
      )
    def cloudWatchLogs: Optional[
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription.ReadOnly
    ]
    def firehose: Optional[
      zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription.ReadOnly
    ]
    def s3
        : Optional[zio.aws.kafkaconnect.model.S3LogDeliveryDescription.ReadOnly]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getFirehose: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("firehose", firehose)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.S3LogDeliveryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDeliveryDescription
  ) extends zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription.ReadOnly {
    override val cloudWatchLogs: Optional[
      zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription
          .wrap(value)
      )
    override val firehose: Optional[
      zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firehose())
      .map(value =>
        zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription.wrap(value)
      )
    override val s3: Optional[
      zio.aws.kafkaconnect.model.S3LogDeliveryDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3())
      .map(value =>
        zio.aws.kafkaconnect.model.S3LogDeliveryDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.WorkerLogDeliveryDescription
  ): zio.aws.kafkaconnect.model.WorkerLogDeliveryDescription.ReadOnly =
    new Wrapper(impl)
}
