package zio.aws.kendra
import zio.aws.kendra.model.PersonasSummary.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.kendra.{
  KendraAsyncClientBuilder,
  KendraAsyncClient
}
import software.amazon.awssdk.services.kendra.model.{
  DisassociatePersonasFromEntitiesResponse,
  DescribeQuerySuggestionsBlockListResponse,
  ListFaqsResponse,
  DescribeExperienceResponse,
  StopDataSourceSyncJobRequest,
  UpdateIndexResponse,
  ClearQuerySuggestionsResponse,
  UpdateQuerySuggestionsBlockListRequest,
  DescribeDataSourceRequest,
  ExperienceEntitiesSummary,
  DescribePrincipalMappingResponse,
  StopDataSourceSyncJobResponse,
  DescribeFaqRequest,
  PersonasSummary,
  AssociatePersonasToEntitiesResponse,
  DeleteFaqResponse,
  QueryResponse,
  UpdateExperienceResponse,
  DescribeThesaurusRequest,
  ListIndicesRequest,
  DeletePrincipalMappingResponse,
  UpdateDataSourceRequest,
  DisassociatePersonasFromEntitiesRequest,
  PutPrincipalMappingResponse,
  GetSnapshotsRequest,
  ListEntityPersonasRequest,
  UpdateQuerySuggestionsBlockListResponse,
  AssociateEntitiesToExperienceResponse,
  GetSnapshotsResponse,
  UpdateExperienceRequest,
  BatchPutDocumentResponse,
  StartDataSourceSyncJobResponse,
  BatchGetDocumentStatusRequest,
  CreateIndexRequest,
  DescribeQuerySuggestionsBlockListRequest,
  GetQuerySuggestionsRequest,
  DeleteDataSourceResponse,
  AssociateEntitiesToExperienceRequest,
  SubmitFeedbackResponse,
  FaqSummary,
  BatchDeleteDocumentResponse,
  GroupSummary,
  ListTagsForResourceRequest,
  CreateQuerySuggestionsBlockListRequest,
  DescribeDataSourceResponse,
  DescribeQuerySuggestionsConfigRequest,
  ListFaqsRequest,
  ListThesauriResponse,
  CreateDataSourceRequest,
  DescribeFaqResponse,
  BatchPutDocumentRequest,
  CreateExperienceRequest,
  DescribeQuerySuggestionsConfigResponse,
  CreateExperienceResponse,
  DeletePrincipalMappingRequest,
  CreateIndexResponse,
  DeleteQuerySuggestionsBlockListResponse,
  ListGroupsOlderThanOrderingIdRequest,
  ClearQuerySuggestionsRequest,
  PutPrincipalMappingRequest,
  UpdateQuerySuggestionsConfigResponse,
  CreateDataSourceResponse,
  CreateThesaurusRequest,
  CreateFaqRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListGroupsOlderThanOrderingIdResponse,
  ListQuerySuggestionsBlockListsResponse,
  ListThesauriRequest,
  ListEntityPersonasResponse,
  DescribePrincipalMappingRequest,
  DeleteExperienceRequest,
  DeleteQuerySuggestionsBlockListRequest,
  ListExperienceEntitiesRequest,
  UpdateDataSourceResponse,
  ListDataSourcesRequest,
  UpdateIndexRequest,
  DataSourceSummary,
  ExperiencesSummary,
  UpdateThesaurusRequest,
  DeleteDataSourceRequest,
  QueryRequest,
  DeleteThesaurusRequest,
  ListQuerySuggestionsBlockListsRequest,
  DataSourceSyncJob,
  ListDataSourceSyncJobsResponse,
  UntagResourceRequest,
  QuerySuggestionsBlockListSummary,
  ThesaurusSummary,
  DeleteExperienceResponse,
  DisassociateEntitiesFromExperienceResponse,
  DeleteFaqRequest,
  DescribeThesaurusResponse,
  SubmitFeedbackRequest,
  ListDataSourcesResponse,
  DeleteIndexResponse,
  GetQuerySuggestionsResponse,
  DescribeExperienceRequest,
  ListExperienceEntitiesResponse,
  CreateFaqResponse,
  IndexConfigurationSummary,
  StartDataSourceSyncJobRequest,
  BatchGetDocumentStatusResponse,
  ListExperiencesRequest,
  DeleteIndexRequest,
  UpdateQuerySuggestionsConfigRequest,
  ListExperiencesResponse,
  DeleteThesaurusResponse,
  TagResourceResponse,
  CreateQuerySuggestionsBlockListResponse,
  DescribeIndexResponse,
  DisassociateEntitiesFromExperienceRequest,
  AssociatePersonasToEntitiesRequest,
  CreateThesaurusResponse,
  ListDataSourceSyncJobsRequest,
  BatchDeleteDocumentRequest,
  TagResourceRequest,
  ListIndicesResponse,
  DescribeIndexRequest,
  UpdateThesaurusResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Kendra extends AspectSupport[Kendra] {
  val api: KendraAsyncClient
  def batchGetDocumentStatus(
      request: zio.aws.kendra.model.BatchGetDocumentStatusRequest
  ): IO[AwsError, zio.aws.kendra.model.BatchGetDocumentStatusResponse.ReadOnly]
  def listQuerySuggestionsBlockLists(
      request: zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly
  ]
  def listQuerySuggestionsBlockListsPaginated(
      request: zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly
  ]
  def updateIndex(
      request: zio.aws.kendra.model.UpdateIndexRequest
  ): IO[AwsError, Unit]
  def describeQuerySuggestionsBlockList(
      request: zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.ReadOnly
  ]
  def createFaq(
      request: zio.aws.kendra.model.CreateFaqRequest
  ): IO[AwsError, zio.aws.kendra.model.CreateFaqResponse.ReadOnly]
  def listIndices(request: zio.aws.kendra.model.ListIndicesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly
  ]
  def listIndicesPaginated(
      request: zio.aws.kendra.model.ListIndicesRequest
  ): IO[AwsError, zio.aws.kendra.model.ListIndicesResponse.ReadOnly]
  def createExperience(
      request: zio.aws.kendra.model.CreateExperienceRequest
  ): IO[AwsError, zio.aws.kendra.model.CreateExperienceResponse.ReadOnly]
  def describeQuerySuggestionsConfig(
      request: zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly
  ]
  def describeDataSource(
      request: zio.aws.kendra.model.DescribeDataSourceRequest
  ): IO[AwsError, zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly]
  def createQuerySuggestionsBlockList(
      request: zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.ReadOnly
  ]
  def updateThesaurus(
      request: zio.aws.kendra.model.UpdateThesaurusRequest
  ): IO[AwsError, Unit]
  def describePrincipalMapping(
      request: zio.aws.kendra.model.DescribePrincipalMappingRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.DescribePrincipalMappingResponse.ReadOnly
  ]
  def associatePersonasToEntities(
      request: zio.aws.kendra.model.AssociatePersonasToEntitiesRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.ReadOnly
  ]
  def updateQuerySuggestionsBlockList(
      request: zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest
  ): IO[AwsError, Unit]
  def associateEntitiesToExperience(
      request: zio.aws.kendra.model.AssociateEntitiesToExperienceRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.AssociateEntitiesToExperienceResponse.ReadOnly
  ]
  def describeThesaurus(
      request: zio.aws.kendra.model.DescribeThesaurusRequest
  ): IO[AwsError, zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly]
  def disassociateEntitiesFromExperience(
      request: zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.DisassociateEntitiesFromExperienceResponse.ReadOnly
  ]
  def stopDataSourceSyncJob(
      request: zio.aws.kendra.model.StopDataSourceSyncJobRequest
  ): IO[AwsError, Unit]
  def listEntityPersonas(
      request: zio.aws.kendra.model.ListEntityPersonasRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listEntityPersonasPaginated(
      request: zio.aws.kendra.model.ListEntityPersonasRequest
  ): IO[AwsError, zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly]
  def clearQuerySuggestions(
      request: zio.aws.kendra.model.ClearQuerySuggestionsRequest
  ): IO[AwsError, Unit]
  def describeIndex(
      request: zio.aws.kendra.model.DescribeIndexRequest
  ): IO[AwsError, zio.aws.kendra.model.DescribeIndexResponse.ReadOnly]
  def createDataSource(
      request: zio.aws.kendra.model.CreateDataSourceRequest
  ): IO[AwsError, zio.aws.kendra.model.CreateDataSourceResponse.ReadOnly]
  def deletePrincipalMapping(
      request: zio.aws.kendra.model.DeletePrincipalMappingRequest
  ): IO[AwsError, Unit]
  def describeFaq(
      request: zio.aws.kendra.model.DescribeFaqRequest
  ): IO[AwsError, zio.aws.kendra.model.DescribeFaqResponse.ReadOnly]
  def getSnapshots(
      request: zio.aws.kendra.model.GetSnapshotsRequest
  ): IO[AwsError, zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly]
  def createThesaurus(
      request: zio.aws.kendra.model.CreateThesaurusRequest
  ): IO[AwsError, zio.aws.kendra.model.CreateThesaurusResponse.ReadOnly]
  def updateExperience(
      request: zio.aws.kendra.model.UpdateExperienceRequest
  ): IO[AwsError, Unit]
  def query(
      request: zio.aws.kendra.model.QueryRequest
  ): IO[AwsError, zio.aws.kendra.model.QueryResponse.ReadOnly]
  def listDataSourceSyncJobs(
      request: zio.aws.kendra.model.ListDataSourceSyncJobsRequest
  ): ZStream[Any, AwsError, zio.aws.kendra.model.DataSourceSyncJob.ReadOnly]
  def listDataSourceSyncJobsPaginated(
      request: zio.aws.kendra.model.ListDataSourceSyncJobsRequest
  ): IO[AwsError, zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly]
  def listDataSources(
      request: zio.aws.kendra.model.ListDataSourcesRequest
  ): ZStream[Any, AwsError, zio.aws.kendra.model.DataSourceSummary.ReadOnly]
  def listDataSourcesPaginated(
      request: zio.aws.kendra.model.ListDataSourcesRequest
  ): IO[AwsError, zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly]
  def disassociatePersonasFromEntities(
      request: zio.aws.kendra.model.DisassociatePersonasFromEntitiesRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.DisassociatePersonasFromEntitiesResponse.ReadOnly
  ]
  def submitFeedback(
      request: zio.aws.kendra.model.SubmitFeedbackRequest
  ): IO[AwsError, Unit]
  def untagResource(
      request: zio.aws.kendra.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.kendra.model.UntagResourceResponse.ReadOnly]
  def updateDataSource(
      request: zio.aws.kendra.model.UpdateDataSourceRequest
  ): IO[AwsError, Unit]
  def listExperiences(
      request: zio.aws.kendra.model.ListExperiencesRequest
  ): ZStream[Any, AwsError, zio.aws.kendra.model.ExperiencesSummary.ReadOnly]
  def listExperiencesPaginated(
      request: zio.aws.kendra.model.ListExperiencesRequest
  ): IO[AwsError, zio.aws.kendra.model.ListExperiencesResponse.ReadOnly]
  def batchDeleteDocument(
      request: zio.aws.kendra.model.BatchDeleteDocumentRequest
  ): IO[AwsError, zio.aws.kendra.model.BatchDeleteDocumentResponse.ReadOnly]
  def deleteDataSource(
      request: zio.aws.kendra.model.DeleteDataSourceRequest
  ): IO[AwsError, Unit]
  def updateQuerySuggestionsConfig(
      request: zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest
  ): IO[AwsError, Unit]
  def batchPutDocument(
      request: zio.aws.kendra.model.BatchPutDocumentRequest
  ): IO[AwsError, zio.aws.kendra.model.BatchPutDocumentResponse.ReadOnly]
  def deleteFaq(
      request: zio.aws.kendra.model.DeleteFaqRequest
  ): IO[AwsError, Unit]
  def getQuerySuggestions(
      request: zio.aws.kendra.model.GetQuerySuggestionsRequest
  ): IO[AwsError, zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly]
  def deleteExperience(
      request: zio.aws.kendra.model.DeleteExperienceRequest
  ): IO[AwsError, zio.aws.kendra.model.DeleteExperienceResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.kendra.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.kendra.model.ListTagsForResourceResponse.ReadOnly]
  def deleteThesaurus(
      request: zio.aws.kendra.model.DeleteThesaurusRequest
  ): IO[AwsError, Unit]
  def tagResource(
      request: zio.aws.kendra.model.TagResourceRequest
  ): IO[AwsError, zio.aws.kendra.model.TagResourceResponse.ReadOnly]
  def deleteIndex(
      request: zio.aws.kendra.model.DeleteIndexRequest
  ): IO[AwsError, Unit]
  def describeExperience(
      request: zio.aws.kendra.model.DescribeExperienceRequest
  ): IO[AwsError, zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly]
  def listThesauri(
      request: zio.aws.kendra.model.ListThesauriRequest
  ): ZStream[Any, AwsError, zio.aws.kendra.model.ThesaurusSummary.ReadOnly]
  def listThesauriPaginated(
      request: zio.aws.kendra.model.ListThesauriRequest
  ): IO[AwsError, zio.aws.kendra.model.ListThesauriResponse.ReadOnly]
  def putPrincipalMapping(
      request: zio.aws.kendra.model.PutPrincipalMappingRequest
  ): IO[AwsError, Unit]
  def listExperienceEntities(
      request: zio.aws.kendra.model.ListExperienceEntitiesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly
  ]
  def listExperienceEntitiesPaginated(
      request: zio.aws.kendra.model.ListExperienceEntitiesRequest
  ): IO[AwsError, zio.aws.kendra.model.ListExperienceEntitiesResponse.ReadOnly]
  def deleteQuerySuggestionsBlockList(
      request: zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest
  ): IO[AwsError, Unit]
  def listFaqs(
      request: zio.aws.kendra.model.ListFaqsRequest
  ): ZStream[Any, AwsError, zio.aws.kendra.model.FaqSummary.ReadOnly]
  def listFaqsPaginated(
      request: zio.aws.kendra.model.ListFaqsRequest
  ): IO[AwsError, zio.aws.kendra.model.ListFaqsResponse.ReadOnly]
  def createIndex(
      request: zio.aws.kendra.model.CreateIndexRequest
  ): IO[AwsError, zio.aws.kendra.model.CreateIndexResponse.ReadOnly]
  def startDataSourceSyncJob(
      request: zio.aws.kendra.model.StartDataSourceSyncJobRequest
  ): IO[AwsError, zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly]
  def listGroupsOlderThanOrderingId(
      request: zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest
  ): ZStream[Any, AwsError, zio.aws.kendra.model.GroupSummary.ReadOnly]
  def listGroupsOlderThanOrderingIdPaginated(
      request: zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest
  ): IO[
    AwsError,
    zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.ReadOnly
  ]
}
object Kendra {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Kendra] = customized(
    identity
  )
  def customized(
      customization: KendraAsyncClientBuilder => KendraAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Kendra] = managed(
    customization
  ).toLayer
  def managed(
      customization: KendraAsyncClientBuilder => KendraAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Kendra] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = KendraAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[KendraAsyncClient, KendraAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[KendraAsyncClient, KendraAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new KendraImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class KendraImpl[R](
      override val api: KendraAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Kendra
      with AwsServiceBase[R] {
    override val serviceName: String = "Kendra"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KendraImpl[R1] = new KendraImpl(api, newAspect, r)
    def batchGetDocumentStatus(
        request: zio.aws.kendra.model.BatchGetDocumentStatusRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.BatchGetDocumentStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetDocumentStatusRequest,
      BatchGetDocumentStatusResponse
    ]("batchGetDocumentStatus", api.batchGetDocumentStatus)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.BatchGetDocumentStatusResponse.wrap)
      .provideEnvironment(r)
    def listQuerySuggestionsBlockLists(
        request: zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListQuerySuggestionsBlockListsRequest,
      ListQuerySuggestionsBlockListsResponse,
      QuerySuggestionsBlockListSummary
    ](
      "listQuerySuggestionsBlockLists",
      api.listQuerySuggestionsBlockLists,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.blockListSummaryItems().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.kendra.model.QuerySuggestionsBlockListSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listQuerySuggestionsBlockListsPaginated(
        request: zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListQuerySuggestionsBlockListsRequest,
      ListQuerySuggestionsBlockListsResponse
    ]("listQuerySuggestionsBlockLists", api.listQuerySuggestionsBlockLists)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.wrap)
      .provideEnvironment(r)
    def updateIndex(
        request: zio.aws.kendra.model.UpdateIndexRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateIndexRequest, UpdateIndexResponse](
        "updateIndex",
        api.updateIndex
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeQuerySuggestionsBlockList(
        request: zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeQuerySuggestionsBlockListRequest,
      DescribeQuerySuggestionsBlockListResponse
    ](
      "describeQuerySuggestionsBlockList",
      api.describeQuerySuggestionsBlockList
    )(request.buildAwsValue())
      .map(zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.wrap)
      .provideEnvironment(r)
    def createFaq(
        request: zio.aws.kendra.model.CreateFaqRequest
    ): IO[AwsError, zio.aws.kendra.model.CreateFaqResponse.ReadOnly] =
      asyncRequestResponse[CreateFaqRequest, CreateFaqResponse](
        "createFaq",
        api.createFaq
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.CreateFaqResponse.wrap)
        .provideEnvironment(r)
    def listIndices(request: zio.aws.kendra.model.ListIndicesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListIndicesRequest,
      ListIndicesResponse,
      IndexConfigurationSummary
    ](
      "listIndices",
      api.listIndices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.indexConfigurationSummaryItems().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kendra.model.IndexConfigurationSummary.wrap(item))
      .provideEnvironment(r)
    def listIndicesPaginated(
        request: zio.aws.kendra.model.ListIndicesRequest
    ): IO[AwsError, zio.aws.kendra.model.ListIndicesResponse.ReadOnly] =
      asyncRequestResponse[ListIndicesRequest, ListIndicesResponse](
        "listIndices",
        api.listIndices
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.ListIndicesResponse.wrap)
        .provideEnvironment(r)
    def createExperience(
        request: zio.aws.kendra.model.CreateExperienceRequest
    ): IO[AwsError, zio.aws.kendra.model.CreateExperienceResponse.ReadOnly] =
      asyncRequestResponse[CreateExperienceRequest, CreateExperienceResponse](
        "createExperience",
        api.createExperience
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.CreateExperienceResponse.wrap)
        .provideEnvironment(r)
    def describeQuerySuggestionsConfig(
        request: zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeQuerySuggestionsConfigRequest,
      DescribeQuerySuggestionsConfigResponse
    ]("describeQuerySuggestionsConfig", api.describeQuerySuggestionsConfig)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.wrap)
      .provideEnvironment(r)
    def describeDataSource(
        request: zio.aws.kendra.model.DescribeDataSourceRequest
    ): IO[AwsError, zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDataSourceRequest,
        DescribeDataSourceResponse
      ]("describeDataSource", api.describeDataSource)(request.buildAwsValue())
        .map(zio.aws.kendra.model.DescribeDataSourceResponse.wrap)
        .provideEnvironment(r)
    def createQuerySuggestionsBlockList(
        request: zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateQuerySuggestionsBlockListRequest,
      CreateQuerySuggestionsBlockListResponse
    ]("createQuerySuggestionsBlockList", api.createQuerySuggestionsBlockList)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.wrap)
      .provideEnvironment(r)
    def updateThesaurus(
        request: zio.aws.kendra.model.UpdateThesaurusRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateThesaurusRequest, UpdateThesaurusResponse](
        "updateThesaurus",
        api.updateThesaurus
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describePrincipalMapping(
        request: zio.aws.kendra.model.DescribePrincipalMappingRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.DescribePrincipalMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePrincipalMappingRequest,
      DescribePrincipalMappingResponse
    ]("describePrincipalMapping", api.describePrincipalMapping)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.DescribePrincipalMappingResponse.wrap)
      .provideEnvironment(r)
    def associatePersonasToEntities(
        request: zio.aws.kendra.model.AssociatePersonasToEntitiesRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociatePersonasToEntitiesRequest,
      AssociatePersonasToEntitiesResponse
    ]("associatePersonasToEntities", api.associatePersonasToEntities)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.wrap)
      .provideEnvironment(r)
    def updateQuerySuggestionsBlockList(
        request: zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateQuerySuggestionsBlockListRequest,
      UpdateQuerySuggestionsBlockListResponse
    ]("updateQuerySuggestionsBlockList", api.updateQuerySuggestionsBlockList)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def associateEntitiesToExperience(
        request: zio.aws.kendra.model.AssociateEntitiesToExperienceRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.AssociateEntitiesToExperienceResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateEntitiesToExperienceRequest,
      AssociateEntitiesToExperienceResponse
    ]("associateEntitiesToExperience", api.associateEntitiesToExperience)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.AssociateEntitiesToExperienceResponse.wrap)
      .provideEnvironment(r)
    def describeThesaurus(
        request: zio.aws.kendra.model.DescribeThesaurusRequest
    ): IO[AwsError, zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly] =
      asyncRequestResponse[DescribeThesaurusRequest, DescribeThesaurusResponse](
        "describeThesaurus",
        api.describeThesaurus
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.DescribeThesaurusResponse.wrap)
        .provideEnvironment(r)
    def disassociateEntitiesFromExperience(
        request: zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.DisassociateEntitiesFromExperienceResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateEntitiesFromExperienceRequest,
      DisassociateEntitiesFromExperienceResponse
    ](
      "disassociateEntitiesFromExperience",
      api.disassociateEntitiesFromExperience
    )(request.buildAwsValue())
      .map(zio.aws.kendra.model.DisassociateEntitiesFromExperienceResponse.wrap)
      .provideEnvironment(r)
    def stopDataSourceSyncJob(
        request: zio.aws.kendra.model.StopDataSourceSyncJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StopDataSourceSyncJobRequest,
      StopDataSourceSyncJobResponse
    ]("stopDataSourceSyncJob", api.stopDataSourceSyncJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listEntityPersonas(
        request: zio.aws.kendra.model.ListEntityPersonasRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListEntityPersonasRequest,
      ListEntityPersonasResponse,
      PersonasSummary
    ](
      "listEntityPersonas",
      api.listEntityPersonas,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaryItems().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kendra.model.PersonasSummary.wrap(item))
      .provideEnvironment(r)
    def listEntityPersonasPaginated(
        request: zio.aws.kendra.model.ListEntityPersonasRequest
    ): IO[AwsError, zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly] =
      asyncRequestResponse[
        ListEntityPersonasRequest,
        ListEntityPersonasResponse
      ]("listEntityPersonas", api.listEntityPersonas)(request.buildAwsValue())
        .map(zio.aws.kendra.model.ListEntityPersonasResponse.wrap)
        .provideEnvironment(r)
    def clearQuerySuggestions(
        request: zio.aws.kendra.model.ClearQuerySuggestionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ClearQuerySuggestionsRequest,
      ClearQuerySuggestionsResponse
    ]("clearQuerySuggestions", api.clearQuerySuggestions)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeIndex(
        request: zio.aws.kendra.model.DescribeIndexRequest
    ): IO[AwsError, zio.aws.kendra.model.DescribeIndexResponse.ReadOnly] =
      asyncRequestResponse[DescribeIndexRequest, DescribeIndexResponse](
        "describeIndex",
        api.describeIndex
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.DescribeIndexResponse.wrap)
        .provideEnvironment(r)
    def createDataSource(
        request: zio.aws.kendra.model.CreateDataSourceRequest
    ): IO[AwsError, zio.aws.kendra.model.CreateDataSourceResponse.ReadOnly] =
      asyncRequestResponse[CreateDataSourceRequest, CreateDataSourceResponse](
        "createDataSource",
        api.createDataSource
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.CreateDataSourceResponse.wrap)
        .provideEnvironment(r)
    def deletePrincipalMapping(
        request: zio.aws.kendra.model.DeletePrincipalMappingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeletePrincipalMappingRequest,
      DeletePrincipalMappingResponse
    ]("deletePrincipalMapping", api.deletePrincipalMapping)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeFaq(
        request: zio.aws.kendra.model.DescribeFaqRequest
    ): IO[AwsError, zio.aws.kendra.model.DescribeFaqResponse.ReadOnly] =
      asyncRequestResponse[DescribeFaqRequest, DescribeFaqResponse](
        "describeFaq",
        api.describeFaq
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.DescribeFaqResponse.wrap)
        .provideEnvironment(r)
    def getSnapshots(
        request: zio.aws.kendra.model.GetSnapshotsRequest
    ): IO[AwsError, zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly] =
      asyncRequestResponse[GetSnapshotsRequest, GetSnapshotsResponse](
        "getSnapshots",
        api.getSnapshots
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.GetSnapshotsResponse.wrap)
        .provideEnvironment(r)
    def createThesaurus(
        request: zio.aws.kendra.model.CreateThesaurusRequest
    ): IO[AwsError, zio.aws.kendra.model.CreateThesaurusResponse.ReadOnly] =
      asyncRequestResponse[CreateThesaurusRequest, CreateThesaurusResponse](
        "createThesaurus",
        api.createThesaurus
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.CreateThesaurusResponse.wrap)
        .provideEnvironment(r)
    def updateExperience(
        request: zio.aws.kendra.model.UpdateExperienceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateExperienceRequest, UpdateExperienceResponse](
        "updateExperience",
        api.updateExperience
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def query(
        request: zio.aws.kendra.model.QueryRequest
    ): IO[AwsError, zio.aws.kendra.model.QueryResponse.ReadOnly] =
      asyncRequestResponse[QueryRequest, QueryResponse]("query", api.query)(
        request.buildAwsValue()
      ).map(zio.aws.kendra.model.QueryResponse.wrap).provideEnvironment(r)
    def listDataSourceSyncJobs(
        request: zio.aws.kendra.model.ListDataSourceSyncJobsRequest
    ): ZStream[Any, AwsError, zio.aws.kendra.model.DataSourceSyncJob.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDataSourceSyncJobsRequest,
        ListDataSourceSyncJobsResponse,
        DataSourceSyncJob
      ](
        "listDataSourceSyncJobs",
        api.listDataSourceSyncJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.history().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kendra.model.DataSourceSyncJob.wrap(item))
        .provideEnvironment(r)
    def listDataSourceSyncJobsPaginated(
        request: zio.aws.kendra.model.ListDataSourceSyncJobsRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDataSourceSyncJobsRequest,
      ListDataSourceSyncJobsResponse
    ]("listDataSourceSyncJobs", api.listDataSourceSyncJobs)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.ListDataSourceSyncJobsResponse.wrap)
      .provideEnvironment(r)
    def listDataSources(
        request: zio.aws.kendra.model.ListDataSourcesRequest
    ): ZStream[Any, AwsError, zio.aws.kendra.model.DataSourceSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDataSourcesRequest,
        ListDataSourcesResponse,
        DataSourceSummary
      ](
        "listDataSources",
        api.listDataSources,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.summaryItems().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kendra.model.DataSourceSummary.wrap(item))
        .provideEnvironment(r)
    def listDataSourcesPaginated(
        request: zio.aws.kendra.model.ListDataSourcesRequest
    ): IO[AwsError, zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly] =
      asyncRequestResponse[ListDataSourcesRequest, ListDataSourcesResponse](
        "listDataSources",
        api.listDataSources
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.ListDataSourcesResponse.wrap)
        .provideEnvironment(r)
    def disassociatePersonasFromEntities(
        request: zio.aws.kendra.model.DisassociatePersonasFromEntitiesRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.DisassociatePersonasFromEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociatePersonasFromEntitiesRequest,
      DisassociatePersonasFromEntitiesResponse
    ]("disassociatePersonasFromEntities", api.disassociatePersonasFromEntities)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.DisassociatePersonasFromEntitiesResponse.wrap)
      .provideEnvironment(r)
    def submitFeedback(
        request: zio.aws.kendra.model.SubmitFeedbackRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[SubmitFeedbackRequest, SubmitFeedbackResponse](
        "submitFeedback",
        api.submitFeedback
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def untagResource(
        request: zio.aws.kendra.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.kendra.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateDataSource(
        request: zio.aws.kendra.model.UpdateDataSourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateDataSourceRequest, UpdateDataSourceResponse](
        "updateDataSource",
        api.updateDataSource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listExperiences(
        request: zio.aws.kendra.model.ListExperiencesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kendra.model.ExperiencesSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListExperiencesRequest,
      ListExperiencesResponse,
      ExperiencesSummary
    ](
      "listExperiences",
      api.listExperiences,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaryItems().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kendra.model.ExperiencesSummary.wrap(item))
      .provideEnvironment(r)
    def listExperiencesPaginated(
        request: zio.aws.kendra.model.ListExperiencesRequest
    ): IO[AwsError, zio.aws.kendra.model.ListExperiencesResponse.ReadOnly] =
      asyncRequestResponse[ListExperiencesRequest, ListExperiencesResponse](
        "listExperiences",
        api.listExperiences
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.ListExperiencesResponse.wrap)
        .provideEnvironment(r)
    def batchDeleteDocument(
        request: zio.aws.kendra.model.BatchDeleteDocumentRequest
    ): IO[AwsError, zio.aws.kendra.model.BatchDeleteDocumentResponse.ReadOnly] =
      asyncRequestResponse[
        BatchDeleteDocumentRequest,
        BatchDeleteDocumentResponse
      ]("batchDeleteDocument", api.batchDeleteDocument)(request.buildAwsValue())
        .map(zio.aws.kendra.model.BatchDeleteDocumentResponse.wrap)
        .provideEnvironment(r)
    def deleteDataSource(
        request: zio.aws.kendra.model.DeleteDataSourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDataSourceRequest, DeleteDataSourceResponse](
        "deleteDataSource",
        api.deleteDataSource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateQuerySuggestionsConfig(
        request: zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateQuerySuggestionsConfigRequest,
      UpdateQuerySuggestionsConfigResponse
    ]("updateQuerySuggestionsConfig", api.updateQuerySuggestionsConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def batchPutDocument(
        request: zio.aws.kendra.model.BatchPutDocumentRequest
    ): IO[AwsError, zio.aws.kendra.model.BatchPutDocumentResponse.ReadOnly] =
      asyncRequestResponse[BatchPutDocumentRequest, BatchPutDocumentResponse](
        "batchPutDocument",
        api.batchPutDocument
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.BatchPutDocumentResponse.wrap)
        .provideEnvironment(r)
    def deleteFaq(
        request: zio.aws.kendra.model.DeleteFaqRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteFaqRequest, DeleteFaqResponse](
        "deleteFaq",
        api.deleteFaq
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getQuerySuggestions(
        request: zio.aws.kendra.model.GetQuerySuggestionsRequest
    ): IO[AwsError, zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly] =
      asyncRequestResponse[
        GetQuerySuggestionsRequest,
        GetQuerySuggestionsResponse
      ]("getQuerySuggestions", api.getQuerySuggestions)(request.buildAwsValue())
        .map(zio.aws.kendra.model.GetQuerySuggestionsResponse.wrap)
        .provideEnvironment(r)
    def deleteExperience(
        request: zio.aws.kendra.model.DeleteExperienceRequest
    ): IO[AwsError, zio.aws.kendra.model.DeleteExperienceResponse.ReadOnly] =
      asyncRequestResponse[DeleteExperienceRequest, DeleteExperienceResponse](
        "deleteExperience",
        api.deleteExperience
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.DeleteExperienceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.kendra.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.kendra.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.kendra.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteThesaurus(
        request: zio.aws.kendra.model.DeleteThesaurusRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteThesaurusRequest, DeleteThesaurusResponse](
        "deleteThesaurus",
        api.deleteThesaurus
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def tagResource(
        request: zio.aws.kendra.model.TagResourceRequest
    ): IO[AwsError, zio.aws.kendra.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteIndex(
        request: zio.aws.kendra.model.DeleteIndexRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteIndexRequest, DeleteIndexResponse](
        "deleteIndex",
        api.deleteIndex
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeExperience(
        request: zio.aws.kendra.model.DescribeExperienceRequest
    ): IO[AwsError, zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeExperienceRequest,
        DescribeExperienceResponse
      ]("describeExperience", api.describeExperience)(request.buildAwsValue())
        .map(zio.aws.kendra.model.DescribeExperienceResponse.wrap)
        .provideEnvironment(r)
    def listThesauri(
        request: zio.aws.kendra.model.ListThesauriRequest
    ): ZStream[Any, AwsError, zio.aws.kendra.model.ThesaurusSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListThesauriRequest,
        ListThesauriResponse,
        ThesaurusSummary
      ](
        "listThesauri",
        api.listThesauri,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.thesaurusSummaryItems().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kendra.model.ThesaurusSummary.wrap(item))
        .provideEnvironment(r)
    def listThesauriPaginated(
        request: zio.aws.kendra.model.ListThesauriRequest
    ): IO[AwsError, zio.aws.kendra.model.ListThesauriResponse.ReadOnly] =
      asyncRequestResponse[ListThesauriRequest, ListThesauriResponse](
        "listThesauri",
        api.listThesauri
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.ListThesauriResponse.wrap)
        .provideEnvironment(r)
    def putPrincipalMapping(
        request: zio.aws.kendra.model.PutPrincipalMappingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutPrincipalMappingRequest,
      PutPrincipalMappingResponse
    ]("putPrincipalMapping", api.putPrincipalMapping)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listExperienceEntities(
        request: zio.aws.kendra.model.ListExperienceEntitiesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListExperienceEntitiesRequest,
      ListExperienceEntitiesResponse,
      ExperienceEntitiesSummary
    ](
      "listExperienceEntities",
      api.listExperienceEntities,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaryItems().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kendra.model.ExperienceEntitiesSummary.wrap(item))
      .provideEnvironment(r)
    def listExperienceEntitiesPaginated(
        request: zio.aws.kendra.model.ListExperienceEntitiesRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.ListExperienceEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListExperienceEntitiesRequest,
      ListExperienceEntitiesResponse
    ]("listExperienceEntities", api.listExperienceEntities)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.ListExperienceEntitiesResponse.wrap)
      .provideEnvironment(r)
    def deleteQuerySuggestionsBlockList(
        request: zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteQuerySuggestionsBlockListRequest,
      DeleteQuerySuggestionsBlockListResponse
    ]("deleteQuerySuggestionsBlockList", api.deleteQuerySuggestionsBlockList)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listFaqs(
        request: zio.aws.kendra.model.ListFaqsRequest
    ): ZStream[Any, AwsError, zio.aws.kendra.model.FaqSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListFaqsRequest,
        ListFaqsResponse,
        FaqSummary
      ](
        "listFaqs",
        api.listFaqs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.faqSummaryItems().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kendra.model.FaqSummary.wrap(item))
        .provideEnvironment(r)
    def listFaqsPaginated(
        request: zio.aws.kendra.model.ListFaqsRequest
    ): IO[AwsError, zio.aws.kendra.model.ListFaqsResponse.ReadOnly] =
      asyncRequestResponse[ListFaqsRequest, ListFaqsResponse](
        "listFaqs",
        api.listFaqs
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.ListFaqsResponse.wrap)
        .provideEnvironment(r)
    def createIndex(
        request: zio.aws.kendra.model.CreateIndexRequest
    ): IO[AwsError, zio.aws.kendra.model.CreateIndexResponse.ReadOnly] =
      asyncRequestResponse[CreateIndexRequest, CreateIndexResponse](
        "createIndex",
        api.createIndex
      )(request.buildAwsValue())
        .map(zio.aws.kendra.model.CreateIndexResponse.wrap)
        .provideEnvironment(r)
    def startDataSourceSyncJob(
        request: zio.aws.kendra.model.StartDataSourceSyncJobRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDataSourceSyncJobRequest,
      StartDataSourceSyncJobResponse
    ]("startDataSourceSyncJob", api.startDataSourceSyncJob)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.StartDataSourceSyncJobResponse.wrap)
      .provideEnvironment(r)
    def listGroupsOlderThanOrderingId(
        request: zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest
    ): ZStream[Any, AwsError, zio.aws.kendra.model.GroupSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListGroupsOlderThanOrderingIdRequest,
        ListGroupsOlderThanOrderingIdResponse,
        GroupSummary
      ](
        "listGroupsOlderThanOrderingId",
        api.listGroupsOlderThanOrderingId,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.groupsSummaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kendra.model.GroupSummary.wrap(item))
        .provideEnvironment(r)
    def listGroupsOlderThanOrderingIdPaginated(
        request: zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest
    ): IO[
      AwsError,
      zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.ReadOnly
    ] = asyncRequestResponse[
      ListGroupsOlderThanOrderingIdRequest,
      ListGroupsOlderThanOrderingIdResponse
    ]("listGroupsOlderThanOrderingId", api.listGroupsOlderThanOrderingId)(
      request.buildAwsValue()
    ).map(zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.wrap)
      .provideEnvironment(r)
  }
  def batchGetDocumentStatus(
      request: zio.aws.kendra.model.BatchGetDocumentStatusRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.BatchGetDocumentStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetDocumentStatus(request))
  def listQuerySuggestionsBlockLists(
      request: zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest
  ): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQuerySuggestionsBlockLists(request))
  def listQuerySuggestionsBlockListsPaginated(
      request: zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQuerySuggestionsBlockListsPaginated(request))
  def updateIndex(
      request: zio.aws.kendra.model.UpdateIndexRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateIndex(request))
  def describeQuerySuggestionsBlockList(
      request: zio.aws.kendra.model.DescribeQuerySuggestionsBlockListRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeQuerySuggestionsBlockList(request))
  def createFaq(request: zio.aws.kendra.model.CreateFaqRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.CreateFaqResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFaq(request))
  def listIndices(request: zio.aws.kendra.model.ListIndicesRequest): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listIndices(request))
  def listIndicesPaginated(
      request: zio.aws.kendra.model.ListIndicesRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListIndicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIndicesPaginated(request))
  def createExperience(
      request: zio.aws.kendra.model.CreateExperienceRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.CreateExperienceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createExperience(request))
  def describeQuerySuggestionsConfig(
      request: zio.aws.kendra.model.DescribeQuerySuggestionsConfigRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeQuerySuggestionsConfig(request))
  def describeDataSource(
      request: zio.aws.kendra.model.DescribeDataSourceRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataSource(request))
  def createQuerySuggestionsBlockList(
      request: zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQuerySuggestionsBlockList(request))
  def updateThesaurus(
      request: zio.aws.kendra.model.UpdateThesaurusRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateThesaurus(request))
  def describePrincipalMapping(
      request: zio.aws.kendra.model.DescribePrincipalMappingRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DescribePrincipalMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePrincipalMapping(request))
  def associatePersonasToEntities(
      request: zio.aws.kendra.model.AssociatePersonasToEntitiesRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associatePersonasToEntities(request))
  def updateQuerySuggestionsBlockList(
      request: zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQuerySuggestionsBlockList(request))
  def associateEntitiesToExperience(
      request: zio.aws.kendra.model.AssociateEntitiesToExperienceRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.AssociateEntitiesToExperienceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateEntitiesToExperience(request))
  def describeThesaurus(
      request: zio.aws.kendra.model.DescribeThesaurusRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeThesaurus(request))
  def disassociateEntitiesFromExperience(
      request: zio.aws.kendra.model.DisassociateEntitiesFromExperienceRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DisassociateEntitiesFromExperienceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateEntitiesFromExperience(request))
  def stopDataSourceSyncJob(
      request: zio.aws.kendra.model.StopDataSourceSyncJobRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopDataSourceSyncJob(request))
  def listEntityPersonas(
      request: zio.aws.kendra.model.ListEntityPersonasRequest
  ): ZStream[zio.aws.kendra.Kendra, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listEntityPersonas(request))
  def listEntityPersonasPaginated(
      request: zio.aws.kendra.model.ListEntityPersonasRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEntityPersonasPaginated(request))
  def clearQuerySuggestions(
      request: zio.aws.kendra.model.ClearQuerySuggestionsRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.clearQuerySuggestions(request))
  def describeIndex(request: zio.aws.kendra.model.DescribeIndexRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DescribeIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIndex(request))
  def createDataSource(
      request: zio.aws.kendra.model.CreateDataSourceRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.CreateDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataSource(request))
  def deletePrincipalMapping(
      request: zio.aws.kendra.model.DeletePrincipalMappingRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePrincipalMapping(request))
  def describeFaq(request: zio.aws.kendra.model.DescribeFaqRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DescribeFaqResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFaq(request))
  def getSnapshots(request: zio.aws.kendra.model.GetSnapshotsRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSnapshots(request))
  def createThesaurus(
      request: zio.aws.kendra.model.CreateThesaurusRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.CreateThesaurusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createThesaurus(request))
  def updateExperience(
      request: zio.aws.kendra.model.UpdateExperienceRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateExperience(request))
  def query(request: zio.aws.kendra.model.QueryRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.QueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.query(request))
  def listDataSourceSyncJobs(
      request: zio.aws.kendra.model.ListDataSourceSyncJobsRequest
  ): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DataSourceSyncJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSourceSyncJobs(request))
  def listDataSourceSyncJobsPaginated(
      request: zio.aws.kendra.model.ListDataSourceSyncJobsRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSourceSyncJobsPaginated(request))
  def listDataSources(
      request: zio.aws.kendra.model.ListDataSourcesRequest
  ): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DataSourceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSources(request))
  def listDataSourcesPaginated(
      request: zio.aws.kendra.model.ListDataSourcesRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSourcesPaginated(request))
  def disassociatePersonasFromEntities(
      request: zio.aws.kendra.model.DisassociatePersonasFromEntitiesRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DisassociatePersonasFromEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociatePersonasFromEntities(request))
  def submitFeedback(
      request: zio.aws.kendra.model.SubmitFeedbackRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.submitFeedback(request))
  def untagResource(request: zio.aws.kendra.model.UntagResourceRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def updateDataSource(
      request: zio.aws.kendra.model.UpdateDataSourceRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDataSource(request))
  def listExperiences(
      request: zio.aws.kendra.model.ListExperiencesRequest
  ): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ExperiencesSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listExperiences(request))
  def listExperiencesPaginated(
      request: zio.aws.kendra.model.ListExperiencesRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListExperiencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExperiencesPaginated(request))
  def batchDeleteDocument(
      request: zio.aws.kendra.model.BatchDeleteDocumentRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.BatchDeleteDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteDocument(request))
  def deleteDataSource(
      request: zio.aws.kendra.model.DeleteDataSourceRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDataSource(request))
  def updateQuerySuggestionsConfig(
      request: zio.aws.kendra.model.UpdateQuerySuggestionsConfigRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateQuerySuggestionsConfig(request))
  def batchPutDocument(
      request: zio.aws.kendra.model.BatchPutDocumentRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.BatchPutDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchPutDocument(request))
  def deleteFaq(
      request: zio.aws.kendra.model.DeleteFaqRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFaq(request))
  def getQuerySuggestions(
      request: zio.aws.kendra.model.GetQuerySuggestionsRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQuerySuggestions(request))
  def deleteExperience(
      request: zio.aws.kendra.model.DeleteExperienceRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DeleteExperienceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteExperience(request))
  def listTagsForResource(
      request: zio.aws.kendra.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteThesaurus(
      request: zio.aws.kendra.model.DeleteThesaurusRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteThesaurus(request))
  def tagResource(request: zio.aws.kendra.model.TagResourceRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteIndex(
      request: zio.aws.kendra.model.DeleteIndexRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteIndex(request))
  def describeExperience(
      request: zio.aws.kendra.model.DescribeExperienceRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExperience(request))
  def listThesauri(request: zio.aws.kendra.model.ListThesauriRequest): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ThesaurusSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listThesauri(request))
  def listThesauriPaginated(
      request: zio.aws.kendra.model.ListThesauriRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListThesauriResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThesauriPaginated(request))
  def putPrincipalMapping(
      request: zio.aws.kendra.model.PutPrincipalMappingRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putPrincipalMapping(request))
  def listExperienceEntities(
      request: zio.aws.kendra.model.ListExperienceEntitiesRequest
  ): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listExperienceEntities(request))
  def listExperienceEntitiesPaginated(
      request: zio.aws.kendra.model.ListExperienceEntitiesRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListExperienceEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExperienceEntitiesPaginated(request))
  def deleteQuerySuggestionsBlockList(
      request: zio.aws.kendra.model.DeleteQuerySuggestionsBlockListRequest
  ): ZIO[zio.aws.kendra.Kendra, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteQuerySuggestionsBlockList(request))
  def listFaqs(request: zio.aws.kendra.model.ListFaqsRequest): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.FaqSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFaqs(request))
  def listFaqsPaginated(request: zio.aws.kendra.model.ListFaqsRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListFaqsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFaqsPaginated(request))
  def createIndex(request: zio.aws.kendra.model.CreateIndexRequest): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.CreateIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIndex(request))
  def startDataSourceSyncJob(
      request: zio.aws.kendra.model.StartDataSourceSyncJobRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDataSourceSyncJob(request))
  def listGroupsOlderThanOrderingId(
      request: zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest
  ): ZStream[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.GroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listGroupsOlderThanOrderingId(request))
  def listGroupsOlderThanOrderingIdPaginated(
      request: zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest
  ): ZIO[
    zio.aws.kendra.Kendra,
    AwsError,
    zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupsOlderThanOrderingIdPaginated(request))
}
